/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.Validator;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.util.PropertyValidator;

public class VAlarm
extends CalendarComponent {
    private static final long serialVersionUID = -8193965477414653802L;
    private final Map actionValidators = new HashMap();
    private final Validator itipValidator;

    public VAlarm() {
        super("VALARM");
        this.actionValidators.put(Action.AUDIO, new AudioValidator());
        this.actionValidators.put(Action.DISPLAY, new DisplayValidator());
        this.actionValidators.put(Action.EMAIL, new EmailValidator());
        this.actionValidators.put(Action.PROCEDURE, new ProcedureValidator());
        this.itipValidator = new ITIPValidator();
    }

    public VAlarm(PropertyList properties) {
        super("VALARM", properties);
        this.actionValidators.put(Action.AUDIO, new AudioValidator());
        this.actionValidators.put(Action.DISPLAY, new DisplayValidator());
        this.actionValidators.put(Action.EMAIL, new EmailValidator());
        this.actionValidators.put(Action.PROCEDURE, new ProcedureValidator());
        this.itipValidator = new ITIPValidator();
    }

    public VAlarm(DateTime trigger) {
        this();
        this.getProperties().add(new Trigger(trigger));
    }

    public VAlarm(Dur trigger) {
        this();
        this.getProperties().add(new Trigger(trigger));
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("ACTION", this.getProperties());
        PropertyValidator.getInstance().assertOne("TRIGGER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("REPEAT", this.getProperties());
        try {
            PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
            PropertyValidator.getInstance().assertNone("REPEAT", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertOne("DURATION", this.getProperties());
            PropertyValidator.getInstance().assertOne("REPEAT", this.getProperties());
        }
        Validator actionValidator = (Validator)this.actionValidators.get(this.getAction());
        if (actionValidator != null) {
            actionValidator.validate();
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return this.itipValidator;
    }

    public final Action getAction() {
        return (Action)this.getProperty("ACTION");
    }

    public final Trigger getTrigger() {
        return (Trigger)this.getProperty("TRIGGER");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final Repeat getRepeat() {
        return (Repeat)this.getProperty("REPEAT");
    }

    public final Attach getAttachment() {
        return (Attach)this.getProperty("ATTACH");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }

    private class ITIPValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ITIPValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("ACTION", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOne("TRIGGER", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("REPEAT", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VAlarm.this.getProperties());
        }
    }

    private class ProcedureValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ProcedureValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("ATTACH", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VAlarm.this.getProperties());
        }
    }

    private class EmailValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private EmailValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DESCRIPTION", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VAlarm.this.getProperties());
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VAlarm.this.getProperties());
        }
    }

    private class DisplayValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private DisplayValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DESCRIPTION", VAlarm.this.getProperties());
        }
    }

    private class AudioValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private AudioValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrLess("ATTACH", VAlarm.this.getProperties());
        }
    }
}

