/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    @Override
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<QueryRequest> request = new DefaultRequest<QueryRequest>(queryRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.Query";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag attributeValueListList;
            ListWithAutoConstructFlag attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (queryRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(queryRequest.getTableName());
            }
            if (queryRequest.getIndexName() != null) {
                jsonWriter.key("IndexName").value(queryRequest.getIndexName());
            }
            if (queryRequest.getSelect() != null) {
                jsonWriter.key("Select").value(queryRequest.getSelect());
            }
            if (!((attributesToGetList = (ListWithAutoConstructFlag)queryRequest.getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (queryRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(queryRequest.getLimit());
            }
            if (queryRequest.isConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value(queryRequest.isConsistentRead());
            }
            if (queryRequest.getKeyConditions() != null) {
                jsonWriter.key("KeyConditions");
                jsonWriter.object();
                for (Map.Entry entry : queryRequest.getKeyConditions().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    jsonWriter.object();
                    attributeValueListList = (ListWithAutoConstructFlag)((Condition)entry.getValue()).getAttributeValueList();
                    if (!(attributeValueListList == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            if (attributeValueListListValue == null) continue;
                            AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                        }
                        jsonWriter.endArray();
                    }
                    if (((Condition)entry.getValue()).getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value(((Condition)entry.getValue()).getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getQueryFilter() != null) {
                jsonWriter.key("QueryFilter");
                jsonWriter.object();
                for (Map.Entry entry : queryRequest.getQueryFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    jsonWriter.object();
                    attributeValueListList = (ListWithAutoConstructFlag)((Condition)entry.getValue()).getAttributeValueList();
                    if (!(attributeValueListList == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            if (attributeValueListListValue == null) continue;
                            AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                        }
                        jsonWriter.endArray();
                    }
                    if (((Condition)entry.getValue()).getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value(((Condition)entry.getValue()).getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value(queryRequest.getConditionalOperator());
            }
            if (queryRequest.isScanIndexForward() != null) {
                jsonWriter.key("ScanIndexForward").value(queryRequest.isScanIndexForward());
            }
            if (queryRequest.getExclusiveStartKey() != null) {
                jsonWriter.key("ExclusiveStartKey");
                jsonWriter.object();
                for (Map.Entry entry : queryRequest.getExclusiveStartKey().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(queryRequest.getReturnConsumedCapacity());
            }
            if (queryRequest.getProjectionExpression() != null) {
                jsonWriter.key("ProjectionExpression").value(queryRequest.getProjectionExpression());
            }
            if (queryRequest.getFilterExpression() != null) {
                jsonWriter.key("FilterExpression").value(queryRequest.getFilterExpression());
            }
            if (queryRequest.getKeyConditionExpression() != null) {
                jsonWriter.key("KeyConditionExpression").value(queryRequest.getKeyConditionExpression());
            }
            if (queryRequest.getExpressionAttributeNames() != null) {
                jsonWriter.key("ExpressionAttributeNames");
                jsonWriter.object();
                for (Map.Entry entry : queryRequest.getExpressionAttributeNames().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    jsonWriter.value(entry.getValue());
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getExpressionAttributeValues() != null) {
                jsonWriter.key("ExpressionAttributeValues");
                jsonWriter.object();
                for (Map.Entry entry : queryRequest.getExpressionAttributeValues().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

