/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.NewPublicVirtualInterface;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreatePublicVirtualInterfaceRequestMarshaller
implements Marshaller<Request<CreatePublicVirtualInterfaceRequest>, CreatePublicVirtualInterfaceRequest> {
    @Override
    public Request<CreatePublicVirtualInterfaceRequest> marshall(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) {
        if (createPublicVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePublicVirtualInterfaceRequest> request = new DefaultRequest<CreatePublicVirtualInterfaceRequest>(createPublicVirtualInterfaceRequest, "AmazonDirectConnect");
        String target = "OvertureService.CreatePublicVirtualInterface";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            NewPublicVirtualInterface newPublicVirtualInterface;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createPublicVirtualInterfaceRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(createPublicVirtualInterfaceRequest.getConnectionId());
            }
            if ((newPublicVirtualInterface = createPublicVirtualInterfaceRequest.getNewPublicVirtualInterface()) != null) {
                ListWithAutoConstructFlag routeFilterPrefixesList;
                jsonWriter.key("newPublicVirtualInterface");
                jsonWriter.object();
                if (newPublicVirtualInterface.getVirtualInterfaceName() != null) {
                    jsonWriter.key("virtualInterfaceName").value(newPublicVirtualInterface.getVirtualInterfaceName());
                }
                if (newPublicVirtualInterface.getVlan() != null) {
                    jsonWriter.key("vlan").value(newPublicVirtualInterface.getVlan());
                }
                if (newPublicVirtualInterface.getAsn() != null) {
                    jsonWriter.key("asn").value(newPublicVirtualInterface.getAsn());
                }
                if (newPublicVirtualInterface.getAuthKey() != null) {
                    jsonWriter.key("authKey").value(newPublicVirtualInterface.getAuthKey());
                }
                if (newPublicVirtualInterface.getAmazonAddress() != null) {
                    jsonWriter.key("amazonAddress").value(newPublicVirtualInterface.getAmazonAddress());
                }
                if (newPublicVirtualInterface.getCustomerAddress() != null) {
                    jsonWriter.key("customerAddress").value(newPublicVirtualInterface.getCustomerAddress());
                }
                if (!((routeFilterPrefixesList = (ListWithAutoConstructFlag)newPublicVirtualInterface.getRouteFilterPrefixes()) == null || routeFilterPrefixesList.isAutoConstruct() && routeFilterPrefixesList.isEmpty())) {
                    jsonWriter.key("routeFilterPrefixes");
                    jsonWriter.array();
                    for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                        if (routeFilterPrefixesListValue == null) continue;
                        jsonWriter.object();
                        if (routeFilterPrefixesListValue.getCidr() != null) {
                            jsonWriter.key("cidr").value(routeFilterPrefixesListValue.getCidr());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

