/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.data;

import static org.junit.Assert.assertEquals;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.junit.Test;
import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.OSGIManifest;

/**
 * {@link OSGIManifestTest}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class OSGIManifestTest {

    public OSGIManifestTest() {
        super();
    }

    @Test
    public void testGetImports() throws IOException {
        URL url = ClassLoader.getSystemResource("org.apache.felix.gogo.command.manifest");
        InputStream is = url.openStream();
        try {
            OSGIManifest manifest = new OSGIManifest(new Manifest(is));
            Set<BundleImport> imports = manifest.getImports();
            Set<BundleImport> expectedImports = new HashSet<BundleImport>();
            expectedImports.add(new BundleImport("org.apache.felix.service.command", false));
            expectedImports.add(new BundleImport("org.osgi.framework", false));
            expectedImports.add(new BundleImport("org.osgi.service.log", false));
            expectedImports.add(new BundleImport("org.osgi.service.packageadmin", false));
            expectedImports.add(new BundleImport("org.osgi.service.startlevel", false));
            expectedImports.add(new BundleImport("org.osgi.util.tracker", false));
            assertEquals("Imports have not been parsed correctly.", expectedImports, imports);
        } finally {
            is.close();
        }
    }

    @Test
    public void testDriveManifest() throws IOException {
        URL url = ClassLoader.getSystemResource("com.openexchange.drive.manifest");
        InputStream is = url.openStream();
        try {
            OSGIManifest manifest = new OSGIManifest(new Manifest(is));
            Set<String> exports = manifest.getExports();
            Set<String> expectedExports = new HashSet<String>();
            expectedExports.add("com.openexchange.drive");
            assertEquals("Exports have not been parsed correctly.", expectedExports, exports);
        } finally {
            is.close();
        }
    }

    @Test
    public void testGlassfishManifest() throws IOException {
        URL url = ClassLoader.getSystemResource("org.glassfish.hk2.locator.manifest");
        InputStream is = url.openStream();
        try {
            OSGIManifest manifest = new OSGIManifest(new Manifest(is));
            Set<BundleImport> imports = manifest.getImports();
            Set<BundleImport> expectedImports = new HashSet<BundleImport>();
            expectedImports.add(new BundleImport("javassist.util.proxy"));
            expectedImports.add(new BundleImport("javax.annotation"));
            expectedImports.add(new BundleImport("javax.inject"));
            expectedImports.add(new BundleImport("org.aopalliance.intercept"));
            expectedImports.add(new BundleImport("org.glassfish.hk2.api"));
            expectedImports.add(new BundleImport("org.glassfish.hk2.extension"));
            expectedImports.add(new BundleImport("org.glassfish.hk2.utilities"));
            expectedImports.add(new BundleImport("org.glassfish.hk2.utilities.cache"));
            expectedImports.add(new BundleImport("org.glassfish.hk2.utilities.reflection"));
            expectedImports.add(new BundleImport("org.jvnet.hk2.annotations"));
            expectedImports.add(new BundleImport("org.objectweb.asm"));
            expectedImports.add(new BundleImport("org.objectweb.asm.commons"));
            assertEquals("Imports have not been parsed correctly.", expectedImports, imports);
        } finally {
            is.close();
        }
    }
    
    /*
     * This test includes an Import with {@code javax.annotation;bundle-symbolic-name="..."} 
     */
    @Test
    public void testGeoLocationCountryManifest() throws IOException {
        URL url = ClassLoader.getSystemResource("com.openexchange.geolocation.country.manifest");
        InputStream is = url.openStream();
        try {
            OSGIManifest manifest = new OSGIManifest(new Manifest(is));
            Set<BundleImport> imports = manifest.getImports();
            Set<BundleImport> expectedImports = new HashSet<BundleImport>();
            expectedImports.add(new BundleImport("javax.annotation"));
            expectedImports.add(new BundleImport("javax.annotation.concurrent"));
            assertEquals("Imports have not been parsed correctly.", expectedImports, imports);
        } finally {
            is.close();
        }
    }
}
