/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.BlockMode;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.BuildTrigger;
import com.openexchange.obs.api.Path;
import com.openexchange.obs.api.Project;
import com.openexchange.obs.api.Repository;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class ProjectWriter {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private ProjectWriter() {
    }

    public static Document write(Project project) throws BuildServiceException {
        Document document;
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            document = builder.newDocument();
            Element projectElem = document.createElement("project");
            document.appendChild(projectElem);
            ProjectWriter.writeProject(project, projectElem);
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        return document;
    }

    private static void writeProject(Project project, Element projectElem) {
        Document document = projectElem.getOwnerDocument();
        projectElem.setAttribute("name", project.getName());
        Element title = document.createElement("title");
        projectElem.appendChild(title);
        Text titleText = document.createTextNode(project.getTitle());
        title.appendChild(titleText);
        Element description = document.createElement("description");
        projectElem.appendChild(description);
        ProjectWriter.writePerson(project, projectElem);
        ProjectWriter.writeBuild(project, projectElem);
        ProjectWriter.writeRepositories(project.getRepositories(), projectElem);
    }

    private static void writePerson(Project project, Element projectElem) {
        Document document = projectElem.getOwnerDocument();
        if (null != project.getPerson()) {
            Element person = document.createElement("person");
            person.setAttribute("userid", project.getPerson());
            person.setAttribute("role", "maintainer");
            projectElem.appendChild(person);
        }
        Element person2 = document.createElement("person");
        projectElem.appendChild(person2);
        person2.setAttribute("userid", "Admin");
        person2.setAttribute("role", "maintainer");
    }

    private static void writeBuild(Project project, Element projectElem) {
        Document document = projectElem.getOwnerDocument();
        if (project.getDisabledRepositories().length == 0) {
            return;
        }
        Element build = document.createElement("build");
        projectElem.appendChild(build);
        if (project.isBuildDisabled()) {
            Element disable = document.createElement("disable");
            build.appendChild(disable);
        }
        for (String repository : project.getDisabledRepositories()) {
            Element disable = document.createElement("disable");
            build.appendChild(disable);
            disable.setAttribute("repository", repository);
        }
    }

    private static void writeRepositories(Repository[] repositories, Element project) {
        Document document = project.getOwnerDocument();
        for (Repository repository : repositories) {
            Element repositoryElement = document.createElement("repository");
            project.appendChild(repositoryElement);
            repositoryElement.setAttribute("name", repository.getName());
            if (!BuildTrigger.DEFAULT.equals((Object)repository.getRebuild())) {
                repositoryElement.setAttribute("rebuild", repository.getRebuild().name().toLowerCase());
            }
            if (!BlockMode.DEFAULT.equals((Object)repository.getBlock())) {
                repositoryElement.setAttribute("block", repository.getBlock().name().toLowerCase());
            }
            ProjectWriter.writePaths(repository.getPaths(), repositoryElement);
            ProjectWriter.writeArchs(repository, repositoryElement);
        }
    }

    private static void writePaths(Path[] paths, Element repository) {
        Document document = repository.getOwnerDocument();
        for (Path path : paths) {
            Element pathElement = document.createElement("path");
            repository.appendChild(pathElement);
            pathElement.setAttribute("repository", path.getRepository().getName());
            pathElement.setAttribute("project", path.getProject().getName());
        }
    }

    private static void writeArchs(Repository repository, Element repositoryElement) {
        Document document = repositoryElement.getOwnerDocument();
        for (Architecture arch : repository.getArch()) {
            Element elementArch = document.createElement("arch");
            repositoryElement.appendChild(elementArch);
            elementArch.appendChild(document.createTextNode(arch.toString()));
        }
    }
}

