/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.util;

import java.util.Iterator;
import java.util.List;

import org.json.*;

public class JSONToolkit {
	/**
	 * Convenience method that searches in a complex JSONObject for a specific sub-JSONObject.
	 * If at any point during the traversal an element (including the root) does not exist,
	 * this method returns null.
	 *
	 * @param root
	 * @param path
	 * @return
	 */
	public static JSONObject getJSONObject(JSONObject root, String... path) {
		return getJSONObject(root, path.length, path);
	}

	public static String getString(JSONObject root, String... path) {
		int limit = path.length - 1;
		JSONObject parent = getJSONObject(root, limit, path);
		if (parent == null || parent.isNull(path[limit]))
			return null;
		return parent.optString(path[limit]);
	}

	private static JSONObject getJSONObject(JSONObject root, int limit, String... path) {
		for (int i = 0; root != null && i < limit; i++)
			root = root.optJSONObject(path[i]);
		return root;
	}

	public static Iterable<String> keys(final JSONObject o) {
		return new Iterable<String>() {
			@SuppressWarnings("unchecked")
			public Iterator<String> iterator() {
				return o.keys();
			}
		};
	}

	public static String[] copyOfKeys(final JSONObject o) {
		List<String> keys = Toolkit.newArrayList(o.length());
		for (String key : keys(o)) {
			keys.add(key);
		}
		return keys.toArray(new String[keys.size()]);
	}

	public static boolean equals(JSONObject o1, JSONObject o2) {
		try {
			for (String prop : JSONToolkit.keys(o1)) {
				if (!o2.has(prop))
					return false;
				Object o1Value = o1.get(prop);
				Object o2Value = o2.get(prop);
				if (o1Value instanceof JSONObject) {
					if (o2Value instanceof JSONObject) {
						if (!JSONToolkit.equals((JSONObject) o1Value, (JSONObject) o2Value))
							return false;
					} else {
						return false;
					}
				} else if (o1Value instanceof JSONArray && o2Value instanceof JSONArray) {
					if (!JSONToolkit.equals((JSONArray) o1Value, (JSONArray) o2Value))
						return false;
				} else {
					if (!o1Value.equals(o2Value))
						return false;
				}
			}
			return true;
		} catch (JSONException e) {
			return false;
		}
	}

	public static boolean equals(JSONArray a1, JSONArray a2) {
		try {
			int length = a1.length();
			for (int i = 0; i < length; i++) {
				Object a1Value = a1.get(i);
				if (!contains(a2, a1Value))
					return false;
			}
			return true;
		} catch (JSONException e) {
			return false;
		}
	}

	public static boolean contains(JSONArray a, Object o) {
		try {
			int length = a.length();
			for (int i = 0; i < length; i++) {
				Object value = a.get(i);
				if (o instanceof JSONObject && value instanceof JSONObject) {
					if (JSONToolkit.equals((JSONObject) value, (JSONObject) o))
						return true;
				} else if (o instanceof JSONArray && value instanceof JSONArray) {
					if (JSONToolkit.equals((JSONArray) value, (JSONArray) o))
						return true;
				} else {
					if (o.equals(value))
						return true;
				}
			}
			return false;
		} catch (JSONException e) {
			return false;
		}
	}

}
