/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.session.impl;

import java.util.Map;

import org.osgi.service.component.ComponentContext;

import com.openexchange.management.ManagementService;
import com.openexchange.timer.TimerService;
import com.openexchange.usm.api.contenttypes.ContentTypeManager;
import com.openexchange.usm.api.contenttypes.FolderContentTypeProvider;
import com.openexchange.usm.api.database.DatabaseAccess;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.api.session.SessionInitializer;
import com.openexchange.usm.api.session.SessionManager;
import com.openexchange.usm.configuration.ConfigurationManager;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.mapping.ObjectIdMappingService;
import com.openexchange.usm.ox_event.OXEventManager;
import com.openexchange.usm.ox_json.OXJSONAccess;
import com.openexchange.usm.uuid.UUIDMappingService;

public class SessionManagerService implements SessionManager {

	private final SessionManagerImpl _delegate = new SessionManagerImpl();

	public Session getSession(String user, String password, String protocol, String device) throws USMException {
		return _delegate.getSession(user, password, protocol, device);
	}

	public Session getSession(String user, String password, String protocol, String device,
			SessionInitializer initializer, String clientIP, Map<String, String> xHeaders) throws USMException {
		return _delegate.getSession(user, password, protocol, device, initializer, clientIP, xHeaders);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		OXJSONAccess ajaxAccess = (OXJSONAccess) context.locateService(OXJSONAccess.class.getName());
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		ContentTypeManager contentTypeManager = (ContentTypeManager) context.locateService(ContentTypeManager.class
				.getName());
		FolderContentTypeProvider folderContentTypeProvider = (FolderContentTypeProvider) context
				.locateService(FolderContentTypeProvider.class.getName());
		OXEventManager oxEventManager = (OXEventManager) context.locateService(OXEventManager.class.getName());
		ConfigurationManager configurationManager = (ConfigurationManager) context
				.locateService(ConfigurationManager.class.getName());
		DatabaseAccess dbAccess = (DatabaseAccess) context.locateService(DatabaseAccess.class.getName());
		ObjectIdMappingService mappingService = (ObjectIdMappingService) context
				.locateService(ObjectIdMappingService.class.getName());
		UUIDMappingService uuidService = (UUIDMappingService) context.locateService(UUIDMappingService.class.getName());
		_delegate.activate(journal.getLog(SessionManager.class), ajaxAccess, contentTypeManager,
				folderContentTypeProvider.getFolderContentType(), oxEventManager, configurationManager, dbAccess,
				mappingService, uuidService);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_delegate.deactivate();
	}

	public void setManagementService(ManagementService managementService) {
		_delegate.setManagementService(managementService);
	}

	public void unsetManagementService(ManagementService managementService) {
		_delegate.setManagementService(null);
	}

	public void setTimerService(TimerService timerService) {
		_delegate.setTimerService(timerService);
	}

	public void unsetTimerService(TimerService timerService) {
		_delegate.setTimerService(null);
	}

	public boolean exitsSessionInDB(String user, String protocol, String device) throws USMException {
		return _delegate.exitsSessionInDB(user, protocol, device);
	}
}
