/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.ant.tasks;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import com.openexchange.obs.api.BuildServiceClient;
import com.openexchange.obs.api.BuildServiceException;

/**
 * Loads a specific log stored on obs and writes that to ant log
 * 
 * @author <a href="mailto:felix.marx@open-xchange.com">Felix Marx</a>
 */
public class LoadLog extends Task {

    private String url;
    private String login;
    private String password;
    private String projectName;
    private String repositoryName;
    private String packageName;

    public LoadLog() {
        super();
    }

    public final void setProjectName(final String projectName) {
        this.projectName = projectName;
    }

    public final void setRepository(final String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public final void setPackageName(final String packageName) {
        this.packageName = packageName;
    }

    public final void setLogin(final String login) {
        this.login = login;
    }

    public final void setPassword(final String password) {
        this.password = password;
    }

    public final void setUrl(final String url) {
        this.url = url;
    }

    @Override
    public void execute() throws BuildException {
        // check ant task arguments
        if (null == url || 0 == url.length()) {
            throw new BuildException("URL of build service is not defined.");
        }
        if (null == login || 0 == login.length()) {
            throw new BuildException("User for authenticating in build service is not defined.");
        }
        if (null == password || 0 == password.length()) {
            throw new BuildException("Password for authenticating in build service is not defined.");
        }
        if (null == projectName || 0 == projectName.length()) {
            throw new BuildException("Project in build service is not defined.");
        }
        if (null == repositoryName || 0 == repositoryName.length()) {
            throw new BuildException("Distribution in build service is not defined.");
        }
        if (null == packageName || 0 == packageName.length()) {
            throw new BuildException("Package in build service is not defined.");
        }

        final BuildServiceClient bsc;
        try {
            bsc = new BuildServiceClient(url, login, password);
            log(bsc.getPackageLogByName(projectName, repositoryName, packageName), Project.MSG_ERR);
        } catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        } catch (final BuildServiceException e) {
            throw new BuildException(e.getMessage(), e);
        } 
    }
}
