/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

/**
 * Reads properties from a 3rdPartyLibs.properties file and can also empty a give set of properties prior to reading the new ones.
 *
 * @author <a href="mailto:felix.marx@open-xchange.com">Felix Marx</a>
 */
public class Create3rdPartyWebpage extends Task {

    Path libs;

    Path propertiesFile;

    Path docs;

    String name;

    String property;

    public Create3rdPartyWebpage() {
        super();
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setProperty(String property) {
        this.property = property;
    }

    public final Path createPropertiesFile() {
        propertiesFile = new Path(getProject());
        return propertiesFile;
    }

    public final Path createLibs() {
        libs = new Path(getProject());
        return libs;
    }

    public final Path createDocs() {
        docs = new Path(getProject());
        return docs;
    }

    @Override
    public final void execute() throws BuildException {
        // checks
        if (libs == null) {
            throw new BuildException("Please define libs.");
        }
        if (docs == null) {
            throw new BuildException("Please define docs.");
        }
        if (propertiesFile == null) {
            throw new BuildException("Please define propertiesFile.");
        }

        // Fill the map for he properties file
        // Additionaly fill another Set which refers to all codesegments
        Map<String, String> propFile = new HashMap<String, String>();
        Set<String> codesegmentSet = new HashSet<String>();
        for (final String filename : propertiesFile.list()) {
            log("Reading " + filename + " for " + name, Project.MSG_DEBUG);
            final Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(filename));
            } catch (IOException e) {
                throw new BuildException("Can not read file \"" + filename + "\".", e);
            }

            for (Object entryKey : properties.keySet()) {
                final String key = (String) entryKey;
                final String value = properties.getProperty(key);
                propFile.put(key, value);
                if(value.contains("codesegment")){
                    codesegmentSet.add(key);
                }
            }
        }

        // Prepare Docs to be a HashMap
        Map<String, String> docsMap = new HashMap<String, String>();
        for (final String filePathName : docs.list()) {
            int index = filePathName.lastIndexOf(File.separatorChar);
            String fileName = filePathName.substring(index + 1);
            docsMap.put(fileName, filePathName);
        }

        final StringBuilder sb = new StringBuilder();
        sb.append("<h3><a name=\""+name+"\"></a>"+name+ "</h3>").append("\n");
        sb.append("<ul>").append("\n");
        
        //Work on the liblist
        for (final String filePathName : libs.list()) {
            int index = filePathName.lastIndexOf(File.separatorChar);
            String fileName = filePathName.substring(index + 1);
            prepareInformation(propFile, docsMap, sb, fileName);
        }
        //Work on the codesegment list
        for (final Iterator iter = codesegmentSet.iterator(); iter.hasNext();) {
            String codeSegmentName = (String) iter.next();
            prepareInformation(propFile, docsMap, sb, codeSegmentName);
        }

        sb.append("</ul>").append("\n");
        getProject().setInheritedProperty(property, sb.toString());
        log(property + ' ' + sb.toString(), Project.MSG_DEBUG);
    }

    private void prepareInformation(Map<String, String> propFile, Map<String, String> docsMap, final StringBuilder sb, String fileName) {
        sb.append("<p />").append("\n");
        getTitle(propFile, fileName, sb);
        sb.append("<ul>").append("\n");
        getCreater(propFile, fileName, sb);
        getWebsite(propFile, fileName, sb);
        getLicenceTyp(propFile, fileName, sb);
        findDoc(propFile, docsMap, fileName,sb);
        
        sb.append("</ul>").append("\n");
    }
    
    private void findDoc(Map<String, String> propFile, Map<String, String> docsMap, String fileName, StringBuilder sb) {
        String docFileName = propFile.get(fileName + ".doc");
        if (null != docFileName) {
            log("The Doc for " + fileName + " is named " + docFileName + ".", Project.MSG_DEBUG);
            String docPathName = docsMap.get(docFileName);
            if (null != docPathName) {
                log("The Path to the Doc for " + fileName + " is " + docPathName + ".", Project.MSG_DEBUG);
                sb.append("<li> licence Artefact used: " + docFileName + " </li>");
            } else {
                throw new BuildException("No Doc for file \"" + fileName + "\".");
            }
        } else {
            log(name + ": No Doc found for file: " + fileName +".", Project.MSG_DEBUG);
            sb.append("<li> No licence artefact used </li>");
        }
        sb.append("\n");
    }
    
    private void getTitle(Map<String, String> propFile,String fileName, StringBuilder sb) {
        String title = propFile.get(fileName + ".specificName");
        if (null != title){
            sb.append(title + " (" + fileName + ")");
        } else {
            sb.append(fileName);
        }
    }
    
    private void getWebsite(Map<String, String> propFile,String fileName, StringBuilder sb) {
        String url = propFile.get(fileName + ".url");
        if (null != url){
            sb.append("<li> <a href=\"" + url + "\" target=\"_top\">" + url + "</a> </li>").append("\n");
        }
    }
    
    private void getCreater(Map<String, String> propFile,String fileName, StringBuilder sb) {
        String creater = propFile.get(fileName + ".creater");
        if (null != creater){
            sb.append("<li> " + creater + "</li>").append("\n");
        }
    }
    
    private void getLicenceTyp(Map<String, String> propFile,String fileName, StringBuilder sb) {
        String licence = propFile.get(fileName + ".licence");
        if (null != licence){
            sb.append("<li> " + licence + " </li>").append("\n");
        }
    }
}
