/*
 * Copyright 2010 Yutaka Obuchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Original is OAuth Java library(http://oauth.googlecode.com/svn/code/java/)
// and modified for OAuth 2.0 Provider

// Original's copyright and license terms
/*
 * Copyright 2007 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.oauth.v2;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.oauth.OAuth;

/**
 * @author Yutaka Obuchi
 *
 */
public class OAuth2Client implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1248154009335279107L;
	
	public final String clientId;
	public final String clientSecret;
    public final String redirectUri;
    private final Map<String, Object> properties;
    
    public OAuth2Client(final String redirectUri, final String clientId,
            final String clientSecret) {
        super();
        properties = new ConcurrentHashMap<String, Object>();
        this.redirectUri = redirectUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    /**
     * Gets the property associated with given name.
     * 
     * @param name The name
     * @return The value or <code>null</code> if absent
     */
    @SuppressWarnings("unchecked")
    public <V> V getProperty(final String name) {
        try {
            return (V) properties.get(name);
        } catch (final ClassCastException e) {
            return null;
        }
    }

    /**
     * Sets specified property.
     * <p>
     * If value is <code>null</code>, a remove is performed.
     * 
     * @param name The name
     * @param value The value (possibly <code>null</code>)
     */
    public void setProperty(final String name, final Object value) {
        if (null == value) {
            properties.remove(name);
        } else {
            properties.put(name, value);
        }
    }

    /**
     * Gets the properties associated with this accessor.
     * 
     * @return The properties' iterator
     */
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return OAuth.unmodifiableIterator(properties.entrySet().iterator());
    }

}
