//Licensed under Apache License version 2.0
//Original license LGPL

// %Z%%M%, %I%, %G%
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package samples;

import java.io.IOException;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

/**
 * Sample Code for Service Registration using JmDNS.
 * <p>
 * To see what happens, launch the TTY browser of JmDNS using the following command:
 *
 * <pre>
 * java -jar lib/jmdns.jar -bs _http._tcp local.
 * </pre>
 *
 * Then run the main method of this class. When you press 'r' and enter, you should see the following output on the TTY
 * browser:
 *
 * <pre>
 * ADD: service[foo._http._tcp.local.,192.168.2.5:1234,path=index.html]
 * </pre>
 *
 * Press 'r' and enter, you should see the following output on the TTY browser:
 *
 * <pre>
 * ADD: service[foo._http._tcp.local.,192.168.2.5:1234,path=index.html]
 * </pre>
 *
 * REMOVE: foo
 *
 * @author Werner Randelshofer
 * @version %I%, %G%
 */
public class RegisterServiceType
{

    /**
     * @param args
     *            the command line arguments
     */
    public static void main(final String[] args)
    {
        /*
         * Activate these lines to see log messages of JmDNS Logger logger = Logger.getLogger(JmDNS.class.getName());
         * ConsoleHandler handler = new ConsoleHandler(); logger.addHandler(handler); logger.setLevel(Level.FINER);
         * handler.setLevel(Level.FINER);
         */

        try
        {
            System.out.println("Opening JmDNS");
            final JmDNS jmdns = JmDNS.create();
            System.out.println("Opened JmDNS");
            System.out.println("\nPress r and Enter, to register Eleven Messaging Service service 'foo'");
            int b;
            while ((b = System.in.read()) != -1 && (char) b != 'r')
            {
                /* Stub */
            }
            final String type = "_eleven._tcp.local.";
            jmdns.registerServiceType(type);

            final String name = "1/eleven.messaging.service";
            final ServiceInfo info = ServiceInfo.create(type, name, 57462, 0, 0, "Eleven messaging service.");
            jmdns.registerService(info);

            System.out.println("\nRegistered Service as " + info);
            System.out.println("Press q and Enter, to quit");
            // int b;
            while ((b = System.in.read()) != -1 && (char) b != 'q')
            {
                /* Stub */
            }
            System.out.println("Unregistering service");
            jmdns.unregisterService(ServiceInfo.create(type, name, 57462, 0, 0, "Eleven messaging service."));
            System.out.println("Done");
            System.out.println("Closing JmDNS");
            jmdns.close();
            System.out.println("Done");
            System.exit(0);
        }
        catch (final IOException e)
        {
            e.printStackTrace();
        }
    }
}
