/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.input;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;

public class ResultSetBuilder {
    private ResultSet rs;
    private ResultSetMetaData rsmd;
    private SQLException exception;
    private Map<String, String> names = new HashMap<String, String>();
    private Map<String, Boolean> attribs = new HashMap<String, Boolean>();
    private Namespace ns = Namespace.NO_NAMESPACE;
    int maxRows = Integer.MAX_VALUE;
    private String rootName = "result";
    private String rowName = "entry";
    private String nullAttribName = null;
    private String nullAttribValue = null;

    public ResultSetBuilder(ResultSet rs) {
        this.rs = rs;
        try {
            this.rsmd = rs.getMetaData();
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public ResultSetBuilder(ResultSet rs, String rootName, String rowName) {
        this(rs);
        this.setRootName(rootName);
        this.setRowName(rowName);
    }

    public ResultSetBuilder(ResultSet rs, String rootName, String rowName, Namespace ns) {
        this(rs, rootName, rowName);
        this.setNamespace(ns);
    }

    public Document build() throws JDOMException {
        if (this.exception != null) {
            throw new JDOMException("Database problem", (Throwable)this.exception);
        }
        try {
            int colCount = this.rsmd.getColumnCount();
            Element root = new Element(this.rootName, this.ns);
            Document doc = new Document(root);
            int rowCount = 0;
            String[] columnName = new String[colCount];
            for (int index = 0; index < colCount; ++index) {
                columnName[index] = this.rsmd.getColumnName(index + 1);
            }
            while (this.rs.next() && rowCount++ < this.maxRows) {
                Element entry = new Element(this.rowName, this.ns);
                for (int col = 1; col <= colCount; ++col) {
                    String name = this.names.isEmpty() ? columnName[col - 1] : this.lookupName(columnName[col - 1]);
                    String value = this.getString(this.rs, col, this.rsmd.getColumnType(col));
                    if (!this.attribs.isEmpty() && this.isAttribute(columnName[col - 1])) {
                        if (this.rs.wasNull()) continue;
                        entry.setAttribute(name, value);
                        continue;
                    }
                    Element child = new Element(name, this.ns);
                    if (!this.rs.wasNull()) {
                        child.setText(value);
                    } else if (this.nullAttribName != null) {
                        child.setAttribute(this.nullAttribName, this.nullAttribValue);
                    }
                    entry.addContent((Content)child);
                }
                root.addContent((Content)entry);
            }
            return doc;
        }
        catch (SQLException e) {
            throw new JDOMException("Database problem", (Throwable)e);
        }
    }

    protected String getString(ResultSet prs, int column, int columnType) throws SQLException {
        Time time;
        Date date;
        Timestamp timeStamp;
        if (columnType == 93 && (timeStamp = prs.getTimestamp(column)) != null) {
            return DateFormat.getDateTimeInstance(0, 0).format(timeStamp);
        }
        if (columnType == 91 && (date = prs.getDate(column)) != null) {
            return DateFormat.getDateInstance(0).format(date);
        }
        if (columnType == 92 && (time = prs.getTime(column)) != null) {
            return DateFormat.getTimeInstance(0).format(time);
        }
        return prs.getString(column);
    }

    private String lookupName(String origName) {
        String name = this.names.get(origName.toLowerCase());
        if (name != null) {
            return name;
        }
        return origName;
    }

    private boolean isAttribute(String origName) {
        Boolean val = this.attribs.get(origName.toLowerCase());
        return val == Boolean.TRUE;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setAsAttribute(String columnName) {
        this.attribs.put(columnName.toLowerCase(), Boolean.TRUE);
    }

    public void setAsAttribute(String columnName, String attribName) {
        this.attribs.put(columnName.toLowerCase(), Boolean.TRUE);
        this.names.put(columnName.toLowerCase(), attribName);
    }

    public void setAsAttribute(int columnNum) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.TRUE);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsAttribute(int columnNum, String attribName) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.TRUE);
            this.names.put(name, attribName);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsElement(String columnName, String elemName) {
        String name = columnName.toLowerCase();
        this.attribs.put(name, Boolean.FALSE);
        this.names.put(name, elemName);
    }

    public void setAsElement(int columnNum, String elemName) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.FALSE);
            this.names.put(name, elemName);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setNullAttribute(String nullAttribName, String nullAttribValue) {
        this.nullAttribName = nullAttribName;
        this.nullAttribValue = nullAttribValue;
    }
}

