/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POIFSContainerDetector
implements Detector {
    private static final long serialVersionUID = -3028021741663605293L;
    public static final MediaType OLE = MediaType.application("x-tika-msoffice");
    public static final MediaType XLS = MediaType.application("vnd.ms-excel");
    public static final MediaType DOC = MediaType.application("msword");
    public static final MediaType PPT = MediaType.application("vnd.ms-powerpoint");
    public static final MediaType PUB = MediaType.application("x-mspublisher");
    public static final MediaType VSD = MediaType.application("vnd.visio");
    public static final MediaType WPS = MediaType.application("vnd.ms-works");
    public static final MediaType MSG = MediaType.application("vnd.ms-outlook");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(8);
        try {
            if (input.read() != 208 || input.read() != 207 || input.read() != 17 || input.read() != 224 || input.read() != 161 || input.read() != 177 || input.read() != 26 || input.read() != 225) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        finally {
            input.reset();
        }
        TikaInputStream tis = TikaInputStream.cast(input);
        if (tis != null) {
            Set<String> names = POIFSContainerDetector.getTopLevelNames(tis);
            if (names.contains("Workbook")) {
                return XLS;
            }
            if (names.contains("EncryptedPackage")) {
                return OLE;
            }
            if (names.contains("WordDocument")) {
                return DOC;
            }
            if (names.contains("Quill")) {
                return PUB;
            }
            if (names.contains("PowerPoint Document")) {
                return PPT;
            }
            if (names.contains("VisioDocument")) {
                return VSD;
            }
            if (names.contains("CONTENTS") && names.contains("SPELLING")) {
                return WPS;
            }
            if (names.contains("CONTENTS")) {
                return OLE;
            }
            if (names.contains("\u0001Ole10Native")) {
                return OLE;
            }
            if (names.contains("PerfectOffice_MAIN")) {
                if (names.contains("SlideShow")) {
                    return MediaType.application("x-corelpresentations");
                }
                if (names.contains("PerfectOffice_OBJECTS")) {
                    return MediaType.application("x-quattro-pro");
                }
            } else {
                if (names.contains("NativeContent_MAIN")) {
                    return MediaType.application("x-quattro-pro");
                }
                for (String name : names) {
                    if (!name.startsWith("__substg1.0_")) continue;
                    return MSG;
                }
            }
        }
        return OLE;
    }

    private static Set<String> getTopLevelNames(TikaInputStream stream) throws IOException {
        FileChannel channel = stream.getFileChannel();
        try {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(channel);
            stream.setOpenContainer(fs);
            HashSet<String> names = new HashSet<String>();
            for (Entry entry : fs.getRoot()) {
                names.add(entry.getName());
            }
            return names;
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }
}

