/*
 * Decompiled with CFR 0.152.
 */
package org.json.helpers;

import java.io.Writer;
import org.json.DynamicCharArray;

public class CharArrayWriter
extends Writer {
    private final DynamicCharArray charArray;

    public CharArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.charArray = new DynamicCharArray(initialSize);
        this.lock = this.charArray;
    }

    @Override
    public void write(int c) {
        this.charArray.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.charArray.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.charArray.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.charArray.append(str.substring(off, off + len));
    }

    @Override
    public CharArrayWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public CharArrayWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.charArray.toString();
    }

    public DynamicCharArray getCharArray() {
        return this.charArray;
    }

    @Override
    public void flush() {
    }

    public void resetCharArray() {
        this.charArray.reset();
    }

    @Override
    public void close() {
    }
}

