/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.CharArray;
import org.json.CharArrayPool;
import org.json.ICharArray;

public class DynamicCharArray
implements ICharArray {
    private final int initialCapacity;
    private CharArray delegatee;

    protected DynamicCharArray() {
        this.initialCapacity = CharArrayPool.getInstance().getSmallLength();
    }

    public DynamicCharArray(int capacity) {
        this.initialCapacity = capacity;
    }

    private CharArray delegatee() {
        CharArray ca = this.delegatee;
        if (ca == null) {
            ca = CharArrayPool.getInstance().getCharArrayFor(this.initialCapacity);
            if (ca == null) {
                ca = new CharArray(this.initialCapacity);
            }
            this.delegatee = ca;
        }
        return ca;
    }

    public DynamicCharArray append(char c) {
        CharArray delegatee = this.delegatee();
        if (delegatee.remainingCapacity() < 1) {
            delegatee = this.increase(delegatee.capacity() + 1);
        }
        delegatee.chars[delegatee.pos++] = c;
        delegatee.hash = null;
        return this;
    }

    public DynamicCharArray append(String s) {
        int len;
        String str = s;
        if (str == null) {
            str = "null";
        }
        if ((len = str.length()) == 0) {
            return this;
        }
        CharArray delegatee = this.delegatee();
        if (delegatee.remainingCapacity() < len) {
            delegatee = this.increase(delegatee.capacity() + len);
        }
        str.getChars(0, len, delegatee.chars, delegatee.pos);
        delegatee.pos += len;
        delegatee.hash = null;
        return this;
    }

    public DynamicCharArray append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public DynamicCharArray append(char[] chars, int offset, int count) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(offset));
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(count));
        }
        if (offset > chars.length - count) {
            throw new IndexOutOfBoundsException(Integer.toString(offset + count));
        }
        CharArray delegatee = this.delegatee();
        if (delegatee.remainingCapacity() < count) {
            delegatee = this.increase(delegatee.capacity() + delegatee.remainingCapacity());
        }
        System.arraycopy(chars, offset, delegatee.chars, delegatee.pos, count);
        delegatee.pos += count;
        delegatee.hash = null;
        return this;
    }

    private CharArray increase(int minCapacity) {
        CharArrayPool pool = CharArrayPool.getInstance();
        CharArray ca = pool.getCharArrayFor(minCapacity);
        if (ca == null) {
            int newCapacity = this.delegatee.capacity() * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            ca = new CharArray(pool.getCharArrayLength(newCapacity));
        }
        ca.copyFrom(this.delegatee);
        pool.offer(this.delegatee);
        this.delegatee = ca;
        return ca;
    }

    @Override
    public void reset() {
        if (this.delegatee != null) {
            CharArrayPool.getInstance().offer(this.delegatee);
            this.delegatee = null;
        }
    }

    @Override
    public int capacity() {
        return this.delegatee().capacity();
    }

    @Override
    public int remainingCapacity() {
        return this.delegatee().remainingCapacity();
    }

    @Override
    public int length() {
        return this.delegatee().length();
    }

    @Override
    public char charAt(int index) {
        return this.delegatee().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.delegatee().subSequence(start, end);
    }

    @Override
    public void copyTo(CharArray other) {
        this.delegatee().copyTo(other);
    }

    @Override
    public void copyFrom(CharArray other) {
        this.delegatee().copyFrom(other);
    }

    @Override
    public String toString() {
        return this.delegatee().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.delegatee == null ? 0 : this.delegatee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DynamicCharArray)) {
            return false;
        }
        DynamicCharArray other = (DynamicCharArray)obj;
        return !(this.delegatee == null ? other.delegatee != null : !this.delegatee.equals(other.delegatee));
    }
}

