/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.json.JSONValue;
import org.json.helpers.StringAllocator;

abstract class AbstractJSONValue
implements JSONValue {
    private static final long serialVersionUID = -1594307735237035381L;
    private static final Constructor<String> STRING_CONSTRUCTOR;
    private static final int BUF_SIZE = 2048;
    private static final int SB_SIZE = 8192;
    private static final JsonGenerator.Feature ESCAPE_NON_ASCII;
    protected static final JsonFactory JSON_FACTORY;
    protected static final MinimalPrettyPrinter STANDARD_MINIMAL_PRETTY_PRINTER;
    protected static final DefaultPrettyPrinter STANDARD_DEFAULT_PRETTY_PRINTER;

    static {
        try {
            Constructor strConstructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
            strConstructor.setAccessible(true);
            STRING_CONSTRUCTOR = strConstructor;
        }
        catch (SecurityException e) {
            throw new IllegalStateException("CharArray initialization failed.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("CharArray initialization failed.", e);
        }
        ESCAPE_NON_ASCII = JsonGenerator.Feature.ESCAPE_NON_ASCII;
        JSON_FACTORY = new JsonFactory();
        STANDARD_MINIMAL_PRETTY_PRINTER = new MinimalPrettyPrinter();
        STANDARD_DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    }

    protected static String readFrom(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        int buflen = 2048;
        char[] cbuf = new char[2048];
        StringAllocator sa = new StringAllocator(8192);
        int read = reader.read(cbuf, 0, 2048);
        while (read > 0) {
            sa.append(cbuf, 0, read);
            read = reader.read(cbuf, 0, 2048);
        }
        if (sa.length() == 0) {
            return null;
        }
        return sa.toString();
    }

    protected static JsonToken nextTokenSafe(JsonParser jParser) throws IOException {
        JsonToken token = null;
        while (token == null) {
            try {
                token = jParser.nextToken();
            }
            catch (JsonParseException e) {
                if (!e.getMessage().startsWith("Unexpected character")) {
                    throw e;
                }
                token = null;
            }
        }
        return token;
    }

    protected static JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        JsonParser jParser = JSON_FACTORY.createParser(reader);
        jParser.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        jParser.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        jParser.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        jParser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
        jParser.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        return jParser;
    }

    protected static JsonGenerator createGenerator(Writer writer, boolean asciiOnly) throws IOException {
        JsonGenerator jGenerator = JSON_FACTORY.createGenerator(writer);
        jGenerator.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        jGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (asciiOnly) {
            jGenerator.enable(ESCAPE_NON_ASCII);
        }
        return jGenerator;
    }

    protected static void writeEndAndFlush(JsonGenerator jGenerator, boolean isJsonObject) {
        if (jGenerator != null) {
            try {
                if (isJsonObject) {
                    jGenerator.writeEndObject();
                } else {
                    jGenerator.writeEndArray();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jGenerator.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static String directString(int off, int len, char[] chars) {
        try {
            return STRING_CONSTRUCTOR.newInstance(off, len, chars);
        }
        catch (Exception e) {
            return new String(chars, off, len);
        }
    }

    protected AbstractJSONValue() {
    }

    protected static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void writeTo(JsonGenerator var1) throws IOException, JSONException;

    protected static void write(Object v, JsonGenerator jGenerator) throws IOException, JSONException {
        if (v == null || JSONObject.NULL.equals(v)) {
            jGenerator.writeNull();
        } else if (v instanceof AbstractJSONValue) {
            ((AbstractJSONValue)v).writeTo(jGenerator);
        } else if (v instanceof JSONString) {
            try {
                String s = ((JSONString)v).toJSONString();
                jGenerator.writeString(s);
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        } else if (v instanceof Number) {
            jGenerator.writeNumber(JSONObject.numberToString((Number)v));
        } else if (v instanceof Boolean) {
            jGenerator.writeBoolean((Boolean)v);
        } else if (jGenerator.isEnabled(ESCAPE_NON_ASCII)) {
            jGenerator.writeString(v.toString());
        } else {
            String str = v.toString();
            if (AbstractJSONValue.escapeNonAscii(str)) {
                int prev = jGenerator.getHighestEscapedChar();
                jGenerator.setHighestNonEscapedChar(127);
                jGenerator.writeString(str);
                jGenerator.setHighestNonEscapedChar(prev);
            } else {
                jGenerator.writeString(str);
            }
        }
    }

    protected static boolean escapeNonAscii(String str) {
        if (str == null) {
            return false;
        }
        return str.indexOf(8232) >= 0 || str.indexOf(8233) >= 0;
    }
}

