/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.GraphicStyle;
import org.jopendocument.dom.ODFrame;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODUserDefinedMeta;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.text.Heading;
import org.jopendocument.dom.text.Paragraph;
import org.jopendocument.dom.text.ParagraphStyle;

public class ODSingleXMLDocumentTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCreate() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt")).toSingle();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
    }

    public void testAdd() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("empty.odt")).toSingle();
        oDSingleXMLDocument.getBody().removeContent();
        ODSingleXMLDocument oDSingleXMLDocument2 = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("styles.odt")).toSingle();
        oDSingleXMLDocument.add(oDSingleXMLDocument2);
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
    }

    public void testAddParagraph() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("styles.odt")).toSingle();
        Paragraph paragraph = new Paragraph();
        paragraph.setStyle("testPragraph");
        paragraph.addContent("Hello");
        paragraph.addTab();
        paragraph.addStyledContent("World", "testChar");
        ODSingleXMLDocumentTest.assertNull((Object)paragraph.getElement().getDocument());
        paragraph.setDocument(oDSingleXMLDocument);
        ODSingleXMLDocumentTest.assertSame((Object)oDSingleXMLDocument.getDocument(), (Object)paragraph.getElement().getDocument());
        Heading heading = new Heading();
        heading.setStyle("inexistantt");
        heading.addContent("Heading text");
        try {
            heading.setDocument(oDSingleXMLDocument);
            ODSingleXMLDocumentTest.fail((String)"should throw since style doesn't exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        heading.setStyle("testPragraph");
        Element element = paragraph.getElement().getParentElement();
        oDSingleXMLDocument.add(heading, element, element.indexOf(paragraph.getElement()));
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
        paragraph.setDocument(null);
        ODSingleXMLDocumentTest.assertNull((Object)paragraph.getElement().getDocument());
    }

    public void testTable() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt")).toSingle();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.getDescendantByName("draw:text-box", "inexistant"));
        Element element = oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable");
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        Table<ODSingleXMLDocument> table = new Table<ODSingleXMLDocument>(oDSingleXMLDocument, element);
        ODSingleXMLDocumentTest.assertEquals((int)1, (int)table.getHeaderRowCount());
        ODSingleXMLDocumentTest.assertEquals((int)0, (int)table.getHeaderColumnCount());
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2005, 0, 12, 12, 35);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)table.getValueAt(2, 1));
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(119.06f), (Object)table.getWidth());
        table.setColumnCount(6, -1, true);
        table.setValueAt(3.14, 5, 0);
        this.assertTableWidth(table, 119.06f);
        float f = table.getColumn(0).getWidth().floatValue() / table.getColumn(1).getWidth().floatValue();
        table.setColumnCount(2, 1, true);
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(f), (Object)Float.valueOf(table.getColumn(0).getWidth().floatValue() / table.getColumn(1).getWidth().floatValue()));
        this.assertTableWidth(table, 119.06f);
        float f2 = table.getColumn(0).getWidth().floatValue();
        table.setColumnCount(4, 0, false);
        this.assertTableWidth(table, 119.06f + 2.0f * f2);
        table.setColumnCount(1, 123, false);
        ODSingleXMLDocumentTest.assertEquals((int)1, (int)table.getColumnCount());
        this.assertTableWidth(table, f2);
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
        table.detach();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable"));
    }

    private void assertTableWidth(Table<?> table, float f) {
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(f), (Object)table.getWidth());
        float f2 = 0.0f;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            f2 += table.getColumn(i).getWidth().floatValue();
        }
        ODSingleXMLDocumentTest.assertEquals((long)this.round(f), (long)this.round(f2));
    }

    private long round(float f) {
        return Math.round((double)f * 100.0) / 100L;
    }

    public void testFrame() throws Exception {
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt"));
        Element element = oDPackage.toSingle().getDescendantByName("draw:frame", "Cadre1");
        ODFrame<ODSingleXMLDocument> oDFrame = new ODFrame<ODSingleXMLDocument>(oDPackage.toSingle(), element);
        ODSingleXMLDocumentTest.assertEquals((Object)new BigDecimal("42.72"), (Object)oDFrame.getWidth());
        ODSingleXMLDocumentTest.assertNull((Object)oDFrame.getHeight());
        ODSingleXMLDocumentTest.assertEquals((String)"right", (String)((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().getHorizontalPosition());
        ODSingleXMLDocumentTest.assertEquals((String)"paragraph", (String)((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().getHorizontalRelation());
        ODSingleXMLDocumentTest.assertEquals(Arrays.asList("position"), ((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().getProtected());
        ODSingleXMLDocumentTest.assertTrue((boolean)((GraphicStyle)oDFrame.getStyle()).getGraphicProperties().isContentPrinted());
    }

    public void testStyle() throws Exception {
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt"));
        Serializable serializable = oDPackage.getContent().getXPath("//draw:ellipse[@draw:name = 'Ellipse']");
        Object object = (Element)((XPath)serializable).selectSingleNode(oDPackage.getContent().getDocument());
        String string = ((Element)object).getAttributeValue("text-style-name", ((Element)object).getNamespace("draw"));
        ParagraphStyle paragraphStyle = ParagraphStyle.DESC.findStyle(oDPackage, oDPackage.getContent().getDocument(), string);
        ODSingleXMLDocumentTest.assertEquals(Collections.singletonList(object), paragraphStyle.getReferences());
        ODXMLDocument oDXMLDocument = oDPackage.getXMLFile("styles.xml");
        XPath xPath = oDXMLDocument.getXPath("//text:p[string() = 'Header']");
        Element element = (Element)xPath.selectSingleNode(oDXMLDocument.getDocument());
        String string2 = new Paragraph(element).getStyleName();
        Element element2 = oDPackage.getStyle(oDPackage.getDocument("styles.xml"), "paragraph", string2);
        Element element3 = oDPackage.getStyle(oDPackage.getDocument("content.xml"), "paragraph", string2);
        ODSingleXMLDocumentTest.assertNotNull((Object)element2);
        ODSingleXMLDocumentTest.assertNotNull((Object)element3);
        ODSingleXMLDocumentTest.assertNotSame((Object)element2, (Object)element3);
        ODSingleXMLDocumentTest.assertEquals(Collections.singletonList(element), StyleStyle.warp(oDPackage, element2).getReferences());
        ODSingleXMLDocumentTest.assertFalse((boolean)StyleStyle.warp(oDPackage, element3).getReferences().contains(element));
        oDPackage.toSingle();
        ODSingleXMLDocumentTest.assertSame((Object)element3, (Object)oDPackage.getStyle(oDPackage.getDocument("content.xml"), "paragraph", string2));
        String string3 = new Paragraph((Element)xPath.selectSingleNode(oDPackage.getContent().getDocument())).getStyleName();
        ODSingleXMLDocumentTest.assertNotNull((Object)string3);
        ODSingleXMLDocumentTest.assertFalse((boolean)string2.equals(string3));
        oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt"));
        serializable = (Element)oDPackage.getContent().getXPath("//text:h[string() = 'Titre 2']").selectSingleNode(oDPackage.getContent().getDocument());
        object = ((Element)serializable).getAttributeValue("style-name", ((Element)serializable).getNamespace());
        ODSingleXMLDocumentTest.assertNull((Object)oDPackage.getContent().getStyle("paragraph", (String)object));
        this.testStyleElem(oDPackage.getXMLFile("styles.xml").getStyle("paragraph", (String)object));
        this.testStyleElem(oDPackage.getStyle("paragraph", (String)object));
        oDPackage.toSingle();
        this.testStyleElem(oDPackage.getContent().getStyle("paragraph", (String)object));
        this.testStyleElem(oDPackage.getStyle("paragraph", (String)object));
    }

    private void testStyleElem(Element element) {
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        ODSingleXMLDocumentTest.assertEquals((String)"2", (String)element.getAttributeValue("default-outline-level", element.getNamespace()));
        ODSingleXMLDocumentTest.assertEquals((String)"Heading", (String)element.getAttributeValue("parent-style-name", element.getNamespace()));
    }

    public void testMeta() throws Exception {
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt"));
        ODMeta oDMeta = oDPackage.getMeta();
        ODSingleXMLDocumentTest.assertEquals((Object)"firstInfo", (Object)oDMeta.getUserMeta("Info 1").getValue());
        ODSingleXMLDocumentTest.assertEquals((Object)"", (Object)oDMeta.getUserMeta("secondName").getValue());
        List<String> list = Arrays.asList("Info 1", "secondName", "Info 3", "Info 4");
        ODSingleXMLDocumentTest.assertEquals(list, oDMeta.getUserMetaNames());
        ODSingleXMLDocumentTest.assertNull((Object)oDMeta.getUserMeta("toto"));
        ODSingleXMLDocumentTest.assertNotNull((Object)oDMeta.getUserMeta("toto", true));
        oDMeta.removeUserMeta("toto");
        ODSingleXMLDocumentTest.assertNull((Object)oDMeta.getUserMeta("toto"));
        ODUserDefinedMeta oDUserDefinedMeta = oDMeta.getUserMeta("toto", true);
        oDUserDefinedMeta.setValue(3.5);
        ODSingleXMLDocumentTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)oDUserDefinedMeta.getValueType()));
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(3.5f), (Object)Float.valueOf(((BigDecimal)oDUserDefinedMeta.getValue()).floatValue()));
        TimeZone timeZone = TimeZone.getTimeZone("Pacific/Marquesas");
        TimeZone timeZone2 = TimeZone.getTimeZone("PST");
        Calendar calendar = Calendar.getInstance(timeZone2);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        oDUserDefinedMeta.setValue(calendar, ODValueType.TIME);
        Calendar calendar2 = (Calendar)oDUserDefinedMeta.getValue();
        ODSingleXMLDocumentTest.assertEquals((int)n, (int)calendar2.get(11));
        ODSingleXMLDocumentTest.assertEquals((int)n2, (int)calendar2.get(12));
        calendar.setTimeZone(timeZone);
        oDUserDefinedMeta.setValue(calendar, ODValueType.TIME);
        calendar2 = (Calendar)oDUserDefinedMeta.getValue();
        ODSingleXMLDocumentTest.assertFalse((n == calendar2.get(11) ? 1 : 0) != 0);
        ODSingleXMLDocumentTest.assertFalse((n2 == calendar2.get(12) ? 1 : 0) != 0);
        calendar.setTimeZone(timeZone2);
        oDUserDefinedMeta.setValue(calendar, ODValueType.DATE);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)oDUserDefinedMeta.getValue());
        calendar.setTimeZone(timeZone);
        oDUserDefinedMeta.setValue(calendar, ODValueType.DATE);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)oDUserDefinedMeta.getValue());
    }
}

