
# norootforbuild
%define         configfiles     configfiles.list

Name:           open-xchange-gui
BuildArch: 	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
BuildRequires:  ant-nodeps
BuildRequires:  java-devel >= 1.6.0
#BuildRequires:  ant ant-nodeps ant-apache-regexp ant-trax gettext-devel
Version:	6.22.0
%define		ox_release 5
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
URL:            http://www.open-xchange.com/
Source:         %{name}_%{version}.orig.tar.bz2
Summary:        Package containing the AJAX gui
%if 0%{?suse_version}
Requires:	apache2
%endif
%if 0%{?fedora_version} || 0%{?rhel_version}
Requires:	httpd
%endif
Requires:	open-xchange-gui-theme-default open-xchange-gui-login-theme-default open-xchange-gui-loading-theme-default open-xchange-gui-l10n-en-us

%description
Package containing the AJAX gui

Authors:
--------
    Open-Xchange

#----------------------------------------------------------------------
%package        themes-default
Group:          Applications/Productivity
Summary:        Package containing the default themes
Provides:       open-xchange-gui-theme-default

%description    themes-default
Package containing the default themes

Authors:
--------
    Open-Xchange

#----------------------------------------------------------------------
%package        login-theme-default
Group:          Applications/Productivity
Summary:        Package containing the login theme

%description    login-theme-default
Package containing the login theme

Authors:
--------
    Open-Xchange

#----------------------------------------------------------------------
%package        loading-theme-default
Group:          Applications/Productivity
Summary:        Package containing the loading theme

%description    loading-theme-default
Package containing the loading theme

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

export ANT_OPTS="-Dfile.encoding=UTF-8 -Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl"
ant -lib lib -Ddestdir=%{buildroot} -Dhtdoc=%{docroot}/ox6 -Dhelplocation=help -Dskip.language=true install
ant -lib lib -Ddestdir=%{buildroot} -Dhtdoc=%{docroot}/ox6 -Dhelplocation=help -Dskip.language=true install-themes

mkdir -p %{buildroot}/opt/open-xchange/etc
mkdir -p %{buildroot}/opt/open-xchange/lib
install -m 644 etc/guipluginfunctions.sh %{buildroot}/opt/open-xchange/lib/guipluginfunctions.sh
# compat link; if not present, old postrms of gui plugins will fail
ln -sf ../lib/guipluginfunctions.sh %{buildroot}/opt/open-xchange/etc/guipluginfunctions.sh
rm -f %{configfiles}
find %{buildroot}/%{docroot}/ox6 -type f -not -regex ".*ox6/themes/.*/.*" -not \( -name languages.js -a -name static.conf \) -printf '"%p"\n' > %{configfiles}
perl -pi -e 's;%{buildroot}/;;' %{configfiles}

%clean
%{__rm} -rf %{buildroot}

%files -f %{configfiles}
%defattr(-,root,root)
%dir %{docroot}/ox6
%dir /opt/open-xchange/etc
%dir /opt/open-xchange/lib
/opt/open-xchange/etc/*
/opt/open-xchange/lib/*
%config(noreplace) %{docroot}/ox6/plugins/static.conf
%doc ChangeLog

%files themes-default
%defattr(-,root,root)
%{docroot}/ox6/themes/default
%{docroot}/ox6/themes/light_breeze

%files login-theme-default
%defattr(-,root,root)
%{docroot}/ox6/themes/login

%files loading-theme-default
%defattr(-,root,root)
%{docroot}/ox6/themes/loading

%changelog
* Wed Oct 10 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
Fifth release candidate for 6.22.0
* Tue Oct 09 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
Fourth release candidate for 6.22.0
* Fri Oct 05 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
Third release candidate for 6.22.0
* Fri Oct 05 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
Second release candidate for 6.22.0
* Tue Aug 21 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
First release candidate for 6.22.0
* Tue Aug 21 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
prepare for 6.22.0
* Thu Aug 09 2012 Viktor Pracht <viktor.pracht@open-xchange.com>
Migrated to Git
