/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

/*global ox, $, config, internalCache, configGetKey, newnode, _, addDOMEvent,
addTranslated, format, removeDOMEvent, removeChildNodes, jQuery, getFullImgSrc,
ComboBox3, noI18n, register, showNode, centerPopupWindow, unregister,
hideNode, OXCache, OXMailMapping, fileloaded */

/*jslint devel: true, browser: true, forin: true, unparam: true, maxerr: 50, indent: 4 */

function computePerm(nBits, nOffset) {
    return (nBits >> nOffset) & (nOffset >= 28 ? 1 : 127);
}

function FolderPath(module) {
    this.module = module;
    this.folderId = null;
    this.nodeId = null;
    this.className = "linkstyle-headline";
    this.classNameD = "font-style-low";
    this.events = [];
    this.cb = function (module, folderId) {
        return function () {
            ox.api.ui.setModule(module, null, folderId);
        };
    };
    this._cancelDraw = false;
}

FolderPath.prototype = {
    
    setFolderId: function (folderId) {
        this.folderId = folderId;
    },
    
    drawDOMNode: function (nodeId, folderId) {
        
        var Self = this;
        
        if (!this.modify_cb) {
            this.modify_cb = function (e) {
                // not mail? not local update? (mail handles this differently)
                if (e.why !== "folder.update.local" && ox.UIController.getModule() !== "mail") {
                    Self.drawDOMNode();
                }
            };
            ox.api.folder.dispatcher.bind("modify", this.modify_cb);
        }
        if (nodeId) {
            this.nodeId = nodeId;
        }
        if (folderId) {
            this.folderId = folderId;
        }
        if (!$(this.nodeId) || !this.folderId || this._cancelDraw) {
            return;
        }
        this._cancelDraw = true;
        
        // get "myself" from user interface first (it is part of most paths and usually cached)
        var userId = config.identifier;
        internalCache.getUsers([userId], function (user) {
            
            // get display name
            var myName = String(user[userId].display_name);
            
            // get path
            ox.api.folder.getParents({
                folder: Self.folderId,
                success: function (list) {
                    
                    Self.clear();
                    
                    var $l = list.length, i = $l - 1, folder;
                    for (; i >= 0; i--) {
                        
                        folder = ox.util.clone(list[i]);
                        
                        if (folder.id === "1") {
                            // overwrite title
                            folder.title = myName;
                        }
                        var read = computePerm(folder.own_rights, 7) > 0;
                        var myNode = newnode("span", 0, { className: read && i > 0  ? Self.className : Self.classNameD },
                            [ document.createTextNode(folder.title) ]);
                        if (read && i > 0) {
                            var fcb = (Self.cb)(folder.module, folder.id);
                            addDOMEvent(myNode, "click", fcb);
                            Self.events.push(["click", fcb]);
                        } 
                        $(Self.nodeId).appendChild(myNode);
                        if (i > 0) {
                            $(Self.nodeId).appendChild(document.createTextNode(" / "));
                        } else if (Self.additionalNode !== undefined) {
                            $(Self.nodeId).appendChild(Self.additionalNode);
                        }
                    }
                    Self._cancelDraw = false;
                }
            });
        });
    },
    
    drawSearch: function (module, searchTerm) {
        if (!this.nodeId || this.module !== module) {
            return;
        }
        this.clear();
        //#. Title for search results (displayed instead of a folder name).
        //#. %s is the search term.
        //#, c-format
        var myNode = newnode("span", 0, 0, [ addTranslated(format(_("Results for \"%s\""), searchTerm)) ]);
        $(this.nodeId).appendChild(myNode);
    },
    clear: function () {
        if (!$(this.nodeId)) {
            return;
        }
        var i = 0, $i = this.events.length;
        for (; i < $i; i++) {
            removeDOMEvent($(this.nodeId), this.events[i][0], this.events[i][1]);
        }
        this.events = [];
        removeChildNodes($(this.nodeId));
        if (this.modify_cb) {
            ox.api.folder.dispatcher.unbind("modify", this.modify_cb);
            this.modify_cb = null;
        }
    }
};

/**
 * Constructor of the subscribe E-Mail folder dialog
 */

window.SubscribeFolder = (function () {
    
    var Class = function () {
        
        var self = this;
        this.changedFolders = []; // temp storage for changed items
        
        // ox.api.cache.mailSubscription.clear();
        
        this.listFolder = function (list, node) {
            // clear content
            jQuery(node).empty();
            // loop over folders
            var i = 0, $l = list.length, folder;
            for (; i < $l; i++) {
                folder = list[i];
                if (ox.api.folder.is("mail", folder)) {
                    self.addFolderToList(folder, node);
                }
            }
            // stop being busy
            jQuery("#subscribe_folder_status").hide();
        };
        
        this.addFolderToList = function (folder, contentNode) {
            
            var sNode = newnode("td", { width: "18px" }, 0, [
                newnode("img", { verticalAlign: "middle" }, {
                    className: folder.subfolders ? "tree-children" : "tree-nochildren",
                    src: folder.subfolders ? getFullImgSrc("img/folderplus.png") : getFullImgSrc("img/noplus.gif")
                })
            ]);
            
            var iNode;
            
            var tNode = newnode("div", {
                marginLeft: "18px", 
                whiteSpace: "nowrap",
                display: "none"
            }, 0);

            sNode.onclick = function () {
                
                if (!folder.subfolders) {
                    return;
                }
                
                if (sNode.firstChild.src.match(/folderplus.png/)) {
                    
                    // be busy
                    jQuery("#subscribe_folder_status").css("opacity", "0.75").show();
                    
                    // get subfolder
                    ox.api.folder.getSubFolders({
                        folder: folder.id,
                        all: true,
                        tree: "0",
                        storage: ox.api.cache.subscribe,
                        success: function (data) {
                            sNode.parentNode.parentNode.parentNode.parentNode.appendChild(tNode);
                            sNode.firstChild.src = getFullImgSrc("img/folderminus.png");
                            sNode.firstChild.className = "tree-nochildren";
                            tNode.style.display = "block";
                            self.listFolder(data, tNode);
                        }
                    });
                } else {
                    sNode.parentNode.parentNode.parentNode.parentNode.removeChild(sNode.parentNode.parentNode.parentNode.nextSibling);
                    sNode.firstChild.src = getFullImgSrc("img/folderplus.png");
                    sNode.firstChild.className = "tree-children";
                }
            };
            
            function checkAllCheckboxes(id, bool_flag) {
                var all_cb = jQuery("#subscribe_folder_content INPUT[type='checkbox']");
                jQuery.each(all_cb, function (i, val) {
                    if (val.id.indexOf(id + "/") !== -1 && val.id !== id) {
                        if (!all_cb[i].disabled) {
                            jQuery(all_cb[i]).attr("checked", bool_flag);
                            self.addChangedItem({ id: val.id.replace(/^sub_folder_/,""),
                                data: { subscribed: bool_flag } });
                        }
                    }
                });
            }
            
            if (folder.own_rights & 0x3f80) {
                iNode = newnode("input", 0, {
                    type: "checkbox",
                    id: "sub_folder_" + folder.id, 
                    oxid: folder.id,
                    className: "noborder",
                    disabled: !(folder.own_rights & 0x3f80)
                });
                /*
                 * setting checked attribute only if folder is subscribed
                 */ 
                if (folder.subscribed === true) {
                    iNode.setAttribute("checked", "checked");
                }  
                iNode.onchange = function () {
                    self.addChangedItem({ id: iNode.oxid, data: { subscribed: iNode.checked } });
                    checkAllCheckboxes("sub_folder_" + iNode.oxid, iNode.checked);
                };
            }
            contentNode.appendChild(
                newnode("div", 0, { className: "tree-div" }, [
                    newnode("table", { borderCollapse: "collapse", borderWidth: "0", borderSpacing: "0", width: "100%" }, 0, [
                        newnode("tbody", { width: "100%" }, 0, [
                            newnode("tr", 0, 0, [
                                sNode,
                                newnode("td", { width: "18px" }, 0, [
                                    newnode("img", { verticalAlign: "middle" }, { src: getFullImgSrc("img/folder/folder_closed.gif") })
                                ]),
                                newnode("td", 0, 0, [ document.createTextNode(folder.title) ]),
                                newnode("td", { width: "30px", verticalAlign: "middle" }, 0, iNode ? [iNode] : 0)
                            ])
                        ])
                    ])
                ])
            );
            /*
             * Workaround to fix checkbox selection bug in IE
             * As long as the node hasn't been appended to the DOM tree IE6 will ignore
             * setting the checked attribute. A timeout takes care that the node will be
             * appended first.
             */
            if (folder.subscribed === true) {
                setTimeout(function () {
                    if (iNode) {
                        iNode.setAttribute("checked", "checked");
                    }
                }, 10);
            }
        };
        
        this.addChangedItem = function (item) {
            var i = 0;
            for (; i < self.changedFolders.length; i++) {
                if (self.changedFolders[i].id === item.id) {
                    self.changedFolders.splice(i, 1);
                    break;
                }
            }
            item.module = "folders";
            item.action = "update";
            item.tree = configGetKey("modules.folder.tree") || 0;
            self.changedFolders.push(item);
        };
        
        this.saveChanges = function () {
            
            if (self.changedFolders.length === 0) {
                self.closeWindow();
                return;
            }
            
            // be busy
            jQuery("#subscribe_folder_status").css("opacity", "0.75").show();
            
            // update
            ox.api.http.PUT({
                module: "multiple",
                data: this.changedFolders,
                appendColumns: false,
                success: function (response) {
                    // some errors?
                    var i = 0, $i = (response || []).length;
                    for (; i < $i; i++) {
                        if (response[i].error) {
                            ox.UINotifier.error(formatError(response[i]));
                        }
                    }
                    // close & update
                    self.closeWindow();
                    ox.api.cache.subscribe.clear();
                    ox.api.folder.refresh({ tree: "0" });
                    ox.api.folder.refresh({ tree: "1" });
                }
            });
        };
        
        this.openWindow = function (options) {
            // get mail accounts
            ox.api.account.all(function (accounts) {
                // init 
                var scrollBar = accounts.length > 3 ? 4 : null;
                var accSel = new ComboBox3(window, "subscribe_folder_account", "20em", 0, true, "cb_subscribe_folder_acc_chd", scrollBar);
                var i = 0, $l = accounts.length;
                for (; i < $l; i++) {
                    accSel.addElement(noI18n(accounts[i].name),
                        "default" + accounts[i].id);
                }
                accSel.getDomNode();
                // select any other default account
                if (options && options.selected) {
                    accSel.setKey("default" + options.selected);
                }
                
                register("cb_subscribe_folder_acc_chd", function () {
                    self.changeAccount(accSel.getKey());
                });
                self.changeAccount(accSel.getKey());
            });
        };
        
        this.changeAccount = function (id) {
            
            // clear changed folders
            this.changedFolders = [];
            
            // set modal
            ox.api.setModal(true);
            
            // be busy
            jQuery("#subscribe_folder_status").css("opacity", "0.75").show();
            
            // get sub folders
            ox.api.folder.getSubFolders({
                folder: id,
                all: true,
                tree: "0", // tree 0 only!
                storage: ox.api.cache.subscribe,
                success: function (list) {
                    // show node
                    showNode("subscribe_folder");
                    // list top-level folders
                    self.listFolder(list, $("subscribe_folder_content"));
                    centerPopupWindow($("subscribe_folder"));
                    $("subscribe_folder").style.display = "block";
                },
                error: function () {
                    // stop being busy
                    jQuery("#subscribe_folder_status").hide();
                }
            });
        };
        
        this.closeWindow = function () {
            unregister("cb_subscribe_folder_acc_chd", window.SubscribeFolder.changeAccount);
            this.changedFolders = [];
            ox.api.folder.refresh({ tree: "0" });
            ox.api.folder.refresh({ tree: "1" });
            hideNode("subscribe_folder");
            $("subscribe_folder").style.display = "none";
            ox.api.setModal(false);
        };
    };
    
    return new Class();
    
}());

register("OX_Folder_Cleared", function (folder_id) {
    var tmpFn = OXCache.join.add(),
        allCollections = OXMailMapping.getSubCollectionsfromObject({ folder_id : folder_id }),
        i = 0;
    for (; i < allCollections.length; i++) {
        OXMailMapping.deleteObjectsInternal(allCollections[i].objects);
    }
    tmpFn();
});

// mark all mails in folder as read
register("OX_Folder_Mark_Read", function (folder_id) {
    ox.api.http.PUT({
        module: "mail",
        params: {
            action: "update",
            folder: folder_id
        },
        data: { flags: 32, value: true },
        success: function (daten) {
            var lock = OXCache.join.add(),
                map = OXMailMapping,
                col = map.getSubCollectionsfromObject({ folder_id: folder_id }),
                i = 0,
                $i = col.length;
            // loop over object & update
            for (; i < $i; i++) {
                map.editObjectsInternal(col[i].objects, null, true, [map.flagmapping.seen]);
            }
            lock();
            // this works fine on current folder -
            // not if user just right clicks on folder to mark as read, so...
            ox.api.folder.update({
                folder: folder_id,
                local: true, // triggers "modify" event which triggers folder tree repaint
                data: { unread: 0 }
            });
        }
    });
});

fileloaded();