/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */

/**
 * Search for Contacts in different Addressbooks
 * makes a liveGrid for Searchresult, an append the selected to a LiveGrid or
 * in a Input field
 * @param {String} searchstring for pattern in the database
 * @param {String} Id of the main search dialog div
 * @param {String} Id of the div for the Livegrid, in the search dialog
 * @param {String} optional: for appending the Contacts in a LiveGrid of the page (deprecated: no longer in use!)
 * @param {String} Id from div, for the selected Contacts in the search dialog
 * @param {String} Id from div, for clearing the search string in the search dialog
 * @param {Array} optional: if suffix of each Inputfield (example: 'to' and 'cc' for newmail_btn_add_to, newmail_btn_add_cc)
 * 
 * the DOM Event as parameter.
 */

function SearchListAddressBook(searchstring, floatingpopupdiv, liveGridDivSearch, liveGridDivResult, divAddContact, searchField, onClose) {
	var Self = this;
	this.emptySearchText = _("Please enter your search");
	this.searchField = searchField;
	this.blurTimer;
	addressbookFolderPath();
	this.divAddContact = divAddContact;
	this.liveGridDivSearch = liveGridDivSearch;
	this.floatingpopupdiv = floatingpopupdiv;
	this.searchstring = searchstring;
	this.internalStorage = new Storage(0, []);
	this.recipientType = "to";	
	$(this.searchField).value = this.emptySearchText;
	this.onClose = onClose;
	addOnClose($(this.floatingpopupdiv), this.closeDiv);
	
    Self.clickOnCombobox = function (e) {
    	if (Self.blurTimer != undefined) {
            clearTimeout(Self.blurTimer);
            delete(Self.blurTimer);
        }
        if ($(searchField).value == Self.emptySearchText) {
            $(searchField).value="";
            $(Self.searchField).style.color="";
        } else if (e.keyCode == 13) {
            Self.searchstring = $(searchField).value;
            Self.getResult();
        }
    };
    
    Self.enterInput = function(e) {
    	Self.blurTimer = setTimeout(function() {
	        if (trimStr($(searchField).value).length == 0) {
	            $(searchField).value=Self.emptySearchText;
	            $(Self.searchField).style.color="silver";
	        }
        }, 100);
    }; 
    
    addDOMEvent($(this.searchField), "keypress", Self.clickOnCombobox);
    addDOMEvent($(this.searchField), "click", Self.clickOnCombobox);
    addDOMEvent($(this.searchField), "blur", Self.enterInput); 
	
    this.searchContacts = function() {
        Self.getResult();
    };
	register("searchContacts", this.searchContacts);
}

SearchListAddressBook.prototype = {

    setAllFolders: function(checkbox, folder_button) {
        if (configGetKey("modules.contacts.singleFolderSearch")) return;
        var setDisabled = classNameSetter("font-color-disabled");
        checkbox.parentNode.parentNode.parentNode.style.display = "";
        checkbox.checked = true;
        setDisabled(folder_button, true);
        checkbox.onclick = function() {
            setDisabled(folder_button, checkbox.checked);
        };
        this.allFoldersCheckbox = checkbox;
    },

	displayError: function(msg) {
        $(this.floatingpopupdiv+"SearchError").style.display = "";
        $(this.floatingpopupdiv+"SearchError").getElementsByTagName("DIV")[0].firstChild.data = msg;
    },
    
	getResult: function() {
		var Self = this;
        this.searchstring = "";
        var inVal = $(this.searchField).value;
        if (trimStr(inVal).length == 0 ||
            inVal == this.emptySearchText) {
            $(this.searchField).value=this.emptySearchText;
            setTimeout(function() {
                $(Self.searchField).style.color="silver";
            },0);
            if (configContainsKey("modules.contacts.mailAddressAutoSearch") &&
                configGetKey("modules.contacts.mailAddressAutoSearch") == false) {
            	this.searchstring = "";
                return;	
            } else if (configContainsKey("minimumSearchCharacters") &&
                configGetKey("minimumSearchCharacters") != 0) {
                this.displayError(
                   //#. %s is the number of characters.
                   //#, c-format
                   format(_("The search pattern requires at least %s characters."), 
                       configGetKey("minimumSearchCharacters")));
                return;
            } else {
            	this.searchstring="";
            }
        } else if (configContainsKey("minimumSearchCharacters") &&
            trimStr(inVal).length < configGetKey("minimumSearchCharacters")) {
            this.displayError(
                //#. %s is the number of characters.
                //#, c-format
                format(_("The search pattern requires at least %s characters."), 
                    configGetKey("minimumSearchCharacters")));
            return;
        } else {
    	   $(Self.searchField).style.color="";
    	   this.searchstring=inVal;
        }
		var pattern = trimStr(this.searchstring) ? this.searchstring : "*";
        var searchObject = {
            display_name: pattern, first_name: pattern, last_name: pattern,
            email1: pattern, email2: pattern, email3: pattern, operator: "or"
        };
        if (configGetKey("language") == "ja_JP") {
            searchObject.yomiFirstName = pattern;
            searchObject.yomiLastName = pattern;
        }
        var criteria = { };
        var lang = ox.api.config.get("language").substring(0, 3);
        if (lang === "zh_") {
            criteria.collation = "gbk";
        }
        
        if (!this.allFoldersCheckbox || !this.allFoldersCheckbox.checked) { 
            criteria.folder_id = clickedItem;
        }
        
        var collection = {
            criteria: criteria,
            search: searchObject,
            columns: [ "id", "folder_id", "display_name", "first_name", "last_name",
                       "email1", "email2", "email3", "distribution_list" ]
        };
        
        var sort = lang == "zh_" || lang == "ja_" ? "last_name" : "sort";
        collection.order = [{ sort: sort, order: "asc" }];
        
        function callback(data) {
            Self.internalStorage = new Storage(0, [], 0, 0, 0, 0, 
                    function(addr) { return addr.folder_id + "." + addr.id + "." + addr.pos; });
            
            if (data && data.objects.length) {
                for (var i = 0; i < data.objects.length; i++) {
                    var obj = data.objects[i];
                    // temp object 
                    var store = { id: obj.id, folder_id: obj.folder_id, pos: 0 };
                    
                    // display name
                    store.display_name = null;
                    if (obj.display_name !== null) {
                        // set the valid display name
                        store.display_name = obj.display_name;
                        
                    } else if (obj.last_name !== null || obj.first_name !== null) {
                        // try to build something based on last and first name
                        store.display_name = (obj.last_name || "") 
                            + ", " + (obj.first_name || "");
                    }
                    
                    if (obj.distribution_list !== null) {
                        // ignore empty lists
                        if (obj.distribution_list.length === 0) {
                            continue;
                        }
                        // store distribution list
                        store.distribution_list = obj.distribution_list;
                        store.mail = null;
                        if (store.display_name === null) {
                            store.display_name = "";
                        }
                        Self.internalStorage.append([ store ]);
                    } else {
                        for (var a in { email1: 1, email2: 1, email3: 1 }) {
                            if (obj[a] !== null && trimStr(obj[a]).length !== 0) {
                                var tmpStore = clone(store);
                                tmpStore.pos = a;
                                tmpStore.mail = obj[a];
                                if (tmpStore.display_name === null) {
                                    tmpStore.display_name = obj[a];
                                }
                                Self.internalStorage.append([ tmpStore ]);
                                tmpStore = null;
                            }
                        }
                    }
                    obj = store = null;
                }
            }
            // enable grid
            distruGrid.selection = new Selection();
            distruGrid.enable(Self.internalStorage);
            gridData = null;
        }
        
        OXCache.newRequest(null, "contacts", collection, jQuery.noop, callback, false);
        
        // clean-up
        collection = sort = criteria = searchObject = lang = pattern = inVal = null;
	},
	
	addToList: function(fieldSuffix) {
	    var Self = this, selCont = distruGrid.selection.getSelected();
	    distruGrid.storage.newIterate(selCont, emptyFunction, function(id, obj) {
	        var tmpObj = clone(obj);
	        if (!tmpObj.distribution_list) {
	            tmpObj = { distribution_list: [ tmpObj ] };
	        }
	        for (var i = 0; i < tmpObj.distribution_list.length; i++) {
	            var tmp = tmpObj.distribution_list[i];
    	        var address = "";
    	        if (!tmp.display_name) {
    	            address = tmp.mail;
    	        } else {
    	            address = quotePersonalAddr(tmp.display_name || "") + " <" + tmp.mail + ">";
    	        }
    	        jQuery("#" + Self.divAddContact + '_' + fieldSuffix).prepend(
                    jQuery("<option>", { value: address }).text(address)
    	        );
    	        address = tmp = null;
	        }
	        tmpObj = null;
	    }, function() {
	        Self = selCont = null;
	    });
	},
	
	resetView: function() {
		if (distruGrid && distruGrid.storage) {
		    distruGrid.selection = new Selection();
			distruGrid.storage.remove(0, distruGrid.storage.ids.length);
		}
	},
	
	resetGrid: function() {
        if (distruGrid && distruGrid.storage) {
        	distruGrid.disable();
        	distruGrid.selection = new Selection();
            this.internalStorage = new Storage(0, []);
            this.makeGrid();
        }
	},
	
	makeGrid: function() {
		var list = $(this.liveGridDivSearch);
		var listHeader = $(this.liveGridDivSearch + "Header");
		if (distruGrid) {
			removeChildNodes(listHeader);
			list.innerHTML = "";
			distruGrid = null;
		}
		
		distruGrid = new LiveGrid([
			{   
				text: "&#xa0;",
				sortable: false,
				width: "26px",
				set: function(div, object) {
				    var src = getFullImgSrc("img/folder/contacts.gif");
				    if (object.distribution_list) {
				        src = getFullImgSrc("img/menu/distributionlist.gif");
				    }
                    if (!div.firstChild) {
                        div.appendChild(newnode("img", {
                            height : "16px",
                            width: "16px"
                        }, {
                            src: getFullImgSrc("img/mail/noattachment.gif"),
                            align: "absmiddle"
                        }));
                    }
                    div.firstChild.src = src;
				},
				clear: function(div) {
				    if (!div.firstChild) {
                        div.appendChild(newnode("img", {
                            height : "16px",
                            width : "16px"
                        }, {
                            src: getFullImgSrc("img/mail/noattachment.gif"),
                            align: "absmiddle"
                        }));
                    } else {
                        div.firstChild.src = getFullImgSrc("img/mail/noattachment.gif");
                    }
				}
			} , {
				text: _("Name"),
				width: "42%",
				set: function(div, object) {
				    if (!div.firstChild) {
                        div.appendChild(div.ownerDocument.createTextNode(object.display_name));
                    } else {
                        div.firstChild.data = object.display_name;
                    }
				},
				clear: function(div) {
				    if (div.firstChild) {
				        div.firstChild.data = "";
				    }
				}
			} , {
    			text: _("E-Mail"),
    			set: function(div, object) {
    			    if (!div.firstChild) {
                        div.appendChild(div.ownerDocument.createTextNode(object.mail || ""));
                    } else {
                        div.firstChild.data = object.mail || "";
                    }
    			},
    			clear: function(div) {
                    if (div.firstChild) {
                        div.firstChild.data = "";
                    }
                }
			}
		], new Selection());
		listHeader.appendChild(distruGrid.getHeader());
		distruGrid.getTable(list);
		
		var Self = this;
		distruGrid.events.register("Activated", 
			function(ids){
		        Self.addToList(Self.recipientType);
			}
		);
	},
	
	openDiv: function() {
	    addressbookFolderPath();
	    centerPopupWindow($(this.floatingpopupdiv));
	    $(this.floatingpopupdiv).style.display = 'block';
	    if (this.onClose) {
	        this.onClose();
	    }
	    this.resetView();
	},
	
	closeDiv: function() {
		this.disableActiveGrids();
		$(this.floatingpopupdiv).style.display = 'none';
	},
	
	disableActiveGrids : function() {
	    if (this.internalStorage) {
	        this.internalStorage.remove(0, this.internalStorage.ids.length);
	    }
	    if (distruGrid) {
	        if (distruGrid.storage) {
	            distruGrid.storage.remove(0, distruGrid.storage.ids.length);
	        }
	        distruGrid.disable();
        }

	},
	
	destroy: function() {
	    this.disableActiveGrids();
	    removeDOMEvent($(this.searchField), "keypress", this.clickOnCombobox);
	    addDOMEvent($(this.searchField), "click", this.clickOnCombobox);
	    addDOMEvent($(this.searchField), "blur", this.enterInput);
	    unregister("searchContacts", this.searchContacts);
	    
	    this.emptySearchText = this.searchField = searchField = this.blurTimer =
	    this.divAddContact = this.liveGridDivSearch = this.floatingpopupdiv = floatingpopupdiv =
	    this.searchstring = searchstring = this.internalStorage = this.recipientType =
	    this.emptySearchText = this.clickOnCombobox = this.enterInput = 
        distruGrid = this.allFoldersCheckbox = Self = contactAddressbookTreeLoaded = 
        treeAddressbookVisible = clickedItem = currentDivIdForAddressbook = 
        addressbookFolderPath = cb_AddressbookGetpath = folderAction = hideAddressbookTree = 
        toggleAddressbookTree = null;
	}
};

var contactAddressbookTreeLoaded = false;
var treeAddressbookVisible = false;
var clickedItem = "";
var currentDivIdForAddressbook = "";

function addressbookFolderPath() {
    ox.api.folder.exists({
        folder: "6",
        success: function (GAL) {
            clickedItem = GAL ? 6 : corewindow.configGetKey("folder.contacts");
            session = corewindow.session;
            var folderViewSettingsNewContact = new Object();
            var folderViewSettingsNewContactById = new Object();
            //Disable Email... 
            folderViewSettingsNewContactById["default"] = 4;
            folderViewSettingsNewContact["contacts"] = 8;
            folderViewSettingsNewContact["calendar"] = 4;
            folderViewSettingsNewContact["tasks"] = 4;
            folderViewSettingsNewContact["infostore"] = 4;
            if (!contactAddressbookTreeLoaded) {
                ox.api.ui.selectFolder({
                    type: "contacts",
                    id: "select-folder-popup-contacts",
                    callback: folderAction,
                    node: $('folderAddressbook_tree_info'),
                    minPerms: 1 << 7, // read own objects
                    destroy: false
                });
                contactAddressbookTreeLoaded = true;
            }
            ox.api.folder.get({ folder: clickedItem, success: cb_AddressbookGetpath});
        }
    });
}

function cb_AddressbookGetpath(data) {
    var vb = document.getElementsByName('newcontact_folder')[0].value = data.title;
}

function folderAction(data) {
    hideAddressbookTree(currentDivIdForAddressbook);
    clickedItem = data.id;
    ox.api.folder.get({ folder: clickedItem, success: cb_AddressbookGetpath });
    triggerEvent("searchContacts");
}

function hideAddressbookTree(divId) {
    $(divId).style.display = "none";
    treeAddressbookVisible = false;
}

function toggleAddressbookTree(divId) {
    currentDivIdForAddressbook = divId;
    if (!treeAddressbookVisible) {
        $(divId).style.display = "block";
        treeAddressbookVisible = true;
    } else {
        $(divId).style.display = "none";
        treeAddressbookVisible = false;
    }
}