/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

// shortcuts
var Tour = ox.api.help.Tour;

// ----------------------------------------------------

// Tour #016
Tour.register({ id: "New6.20", title: _("Guided Tour: New in 6.20"), src: "tour-016-whatsnew.xml", plugin: NAME });

// Tour #030
Tour.register({ id: "GuidedMail", title: _("Guided Tour: E-Mail"), src: "tour-030-email.xml", plugin: NAME });

// Tour #040
if (ox.upsell.matrix.hasFeature("contacts")) {
    Tour.register({ id: "GuidedContacts", title: _("Guided Tour: Contacts"), src: "tour-040-contacts.xml", plugin: NAME });
}

// Tour #050
if (ox.upsell.matrix.hasFeature("calendar")) {
    Tour.register({ id: "GuidedCalendar", title: _("Guided Tour: Calendar"), src: "tour-050-calendar.xml", plugin: NAME });
}

// Tour #060
if (ox.upsell.matrix.hasFeature("tasks")) {
    Tour.register({ id: "GuidedTasks", title: _("Guided Tour: Tasks"), src: "tour-060-tasks.xml", plugin: NAME });
}

// Tour #060
if (ox.upsell.matrix.hasFeature("infostore")) {
    Tour.register({ id: "GuidedInfoStore", title: _("Guided Tour: InfoStore"), src: "tour-070-infostore.xml", plugin: NAME });
}

//----------------------------------------------------

/*
 * Add to help menu
 */
register("Ready", function() {
    // trigger event
    triggerEvent("ToursDefined");
    // add tours to help menu
    var menu = globalContextMenus.help;
    // loop
    jQuery.each(Tour.list(), function (id, tour) {
        menu.addItem(new MenuItem(tour.title, function () {
            Tour.load(id);
        }));
    });
});
