/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.rmi.dataobjects;

import com.openexchange.admin.rmi.dataobjects.EnforceableDataObject;
import com.openexchange.admin.rmi.exceptions.DuplicateExtensionException;
import com.openexchange.admin.rmi.extensions.OXCommonExtension;
import java.io.Serializable;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendableDataObject
extends EnforceableDataObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5125311385480887183L;
    private Hashtable<String, OXCommonExtension> extensions = null;
    private final boolean extensionsset = false;
    private boolean extensionsok = true;

    public void addExtension(OXCommonExtension extension) throws DuplicateExtensionException {
        String extensionName = extension.getClass().getName();
        if (this.extensions.containsKey(extensionName)) {
            throw new DuplicateExtensionException(extensionName);
        }
        this.extensions.put(extensionName, extension);
    }

    public Hashtable<String, OXCommonExtension> getAllExtensionsAsHash() {
        return this.extensions;
    }

    public OXCommonExtension getFirstExtensionByName(String extname) {
        return this.extensions.get(extname);
    }

    public boolean isExtensionsok() {
        return this.extensionsok;
    }

    public boolean isExtensionsset() {
        return false;
    }

    public boolean removeExtension(OXCommonExtension extension) {
        return null != this.extensions.remove(extension.getClass().getName());
    }

    public final void setExtensionsok(boolean extensionsok) {
        this.extensionsok = extensionsok;
    }

    protected void initExtendable() {
        this.extensions = new Hashtable(3);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ExtendableDataObject object = (ExtendableDataObject)super.clone();
        if (this.extensions != null) {
            object.extensions = new Hashtable<String, OXCommonExtension>(this.extensions);
        }
        return object;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(super.toString());
        for (OXCommonExtension usrext : this.extensions.values()) {
            ret.append("  ");
            ret.append("Extension ");
            ret.append(usrext.getClass().getName());
            ret.append(" contains: \n");
            ret.append("  ");
            ret.append(usrext.toString());
            ret.append("\n");
        }
        return ret.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = 31 * result + (this.extensionsok ? 1231 : 1237);
        result = 31 * result + 1237;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExtendableDataObject)) {
            return false;
        }
        ExtendableDataObject other = (ExtendableDataObject)obj;
        if (this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions)) {
            return false;
        }
        if (this.extensionsok != other.extensionsok) {
            return false;
        }
        return false == other.extensionsset;
    }
}

