/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.rmi.dataobjects;

import com.openexchange.admin.rmi.exceptions.EnforceableDataObjectException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnforceableDataObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9068912974174606869L;
    private ArrayList<String> unset_members = new ArrayList();

    public abstract String[] getMandatoryMembersCreate();

    public abstract String[] getMandatoryMembersChange();

    public abstract String[] getMandatoryMembersDelete();

    public abstract String[] getMandatoryMembersRegister();

    public boolean mandatoryCreateMembersSet() throws EnforceableDataObjectException {
        return this.mandatoryMembersSet(this.getMandatoryMembersCreate());
    }

    public boolean mandatoryChangeMembersSet() throws EnforceableDataObjectException {
        return this.mandatoryMembersSet(this.getMandatoryMembersChange());
    }

    public boolean mandatoryDeleteMembersSet() throws EnforceableDataObjectException {
        return this.mandatoryMembersSet(this.getMandatoryMembersDelete());
    }

    public boolean mandatoryRegisterMembersSet() throws EnforceableDataObjectException {
        return this.mandatoryMembersSet(this.getMandatoryMembersRegister());
    }

    private boolean mandatoryMembersSet(String[] members) throws EnforceableDataObjectException {
        this.unset_members.clear();
        try {
            if (members != null && members.length > 0) {
                for (String m : members) {
                    Field f = this.getClass().getDeclaredField(m);
                    f.setAccessible(true);
                    Object val = f.get(this);
                    if (val != null && (!(val instanceof String) || !((String)val).equals(""))) continue;
                    this.unset_members.add(m);
                }
                return this.unset_members.size() <= 0;
            }
            return true;
        }
        catch (SecurityException e) {
            throw new EnforceableDataObjectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new EnforceableDataObjectException("No such member: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new EnforceableDataObjectException(e);
        }
        catch (IllegalAccessException e) {
            throw new EnforceableDataObjectException(e);
        }
    }

    public ArrayList<String> getUnsetMembers() {
        return this.unset_members;
    }

    protected Object clone() throws CloneNotSupportedException {
        EnforceableDataObject object = (EnforceableDataObject)super.clone();
        object.unset_members = new ArrayList<String>(this.unset_members);
        return object;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(super.toString());
        ret.append("\n");
        ret.append(" Mandatory members:\n");
        ret.append("  Create: ");
        if (this.getMandatoryMembersCreate() != null && this.getMandatoryMembersCreate().length > 0) {
            for (String m : this.getMandatoryMembersCreate()) {
                ret.append(m);
                ret.append(" ");
            }
            ret.append("\n");
        } else {
            ret.append(" NONE\n");
        }
        ret.append("  Change:");
        if (this.getMandatoryMembersChange() != null && this.getMandatoryMembersChange().length > 0) {
            for (String m : this.getMandatoryMembersChange()) {
                ret.append(m);
                ret.append(" ");
            }
            ret.append("\n");
        } else {
            ret.append(" NONE\n");
        }
        ret.append("  Delete:");
        if (this.getMandatoryMembersDelete() != null && this.getMandatoryMembersDelete().length > 0) {
            for (String m : this.getMandatoryMembersDelete()) {
                ret.append(m);
                ret.append(" ");
            }
            ret.append("\n");
        } else {
            ret.append(" NONE\n");
        }
        ret.append("  Register:");
        if (this.getMandatoryMembersRegister() != null && this.getMandatoryMembersRegister().length > 0) {
            for (String m : this.getMandatoryMembersRegister()) {
                ret.append(m);
                ret.append(" ");
            }
            ret.append("\n");
        } else {
            ret.append(" NONE\n");
        }
        return ret.toString();
    }

    public void testMandatoryCreateFieldsNull() throws InvalidDataException {
        String[] mandatoryMembersCreate = this.getMandatoryMembersCreate();
        try {
            for (String name : mandatoryMembersCreate) {
                StringBuilder sb = new StringBuilder("get");
                String firstletter = name.substring(0, 1).toUpperCase();
                sb.append(firstletter);
                String lasttext = name.substring(1);
                sb.append(lasttext);
                Class<?> class1 = this.getClass();
                Method getter = class1.getMethod(sb.toString(), null);
                sb = new StringBuilder("is");
                sb.append(firstletter);
                sb.append(lasttext);
                sb.append("set");
                Method isset = this.getClass().getMethod(sb.toString(), null);
                Object getresult = getter.invoke((Object)this, (Object[])null);
                boolean issetresult = (Boolean)isset.invoke((Object)this, (Object[])null);
                if (!issetresult || null != getresult) continue;
                throw new InvalidDataException("Field \"" + name + "\" is a mandatory field and can't be set to null.");
            }
        }
        catch (SecurityException e) {
            throw new InvalidDataException(e);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidDataException("No such method " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidDataException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidDataException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unset_members == null ? 0 : this.unset_members.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnforceableDataObject)) {
            return false;
        }
        EnforceableDataObject other = (EnforceableDataObject)obj;
        return !(this.unset_members == null ? other.unset_members != null : !this.unset_members.equals(other.unset_members));
    }
}

