/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.taskmanagement;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.BasicCommandlineOptions;
import com.openexchange.admin.console.CLIIllegalOptionValueException;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.CLIParseException;
import com.openexchange.admin.console.CLIUnknownOptionException;
import com.openexchange.admin.rmi.OXTaskMgmtInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.MissingOptionException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import com.openexchange.admin.rmi.exceptions.TaskManagerException;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;

public class JobControl
extends BasicCommandlineOptions {
    private static final char OPT_LIST_SHORT = 'l';
    private static final String OPT_LIST_LONG = "list";
    private static final char OPT_DELETE_SHORT = 'd';
    private static final String OPT_DELETE_LONG = "delete";
    private static final char OPT_DETAILS_SHORT = 't';
    private static final String OPT_DETAILS_LONG = "details";
    private static final String OPT_FLUSH_LONG = "flush";
    private static final char OPT_FLUSH_SHORT = 'f';
    private CLIOption list = null;
    private CLIOption delete = null;
    private CLIOption details = null;
    private CLIOption flush = null;

    public static void main(String[] args) {
        new JobControl(args);
    }

    public JobControl(String[] args2) {
        AdminParser parser = new AdminParser("jobControl");
        this.setOptions(parser);
        try {
            parser.ownparse(args2);
            Context ctx = new Context(1);
            if (parser.getOptionValue(this.contextOption) != null) {
                ctx.setId(Integer.parseInt((String)parser.getOptionValue(this.contextOption)));
            }
            Credentials auth = new Credentials((String)parser.getOptionValue(this.adminUserOption), (String)parser.getOptionValue(this.adminPassOption));
            OXTaskMgmtInterface oxtask = (OXTaskMgmtInterface)Naming.lookup(RMI_HOSTNAME + "OXTaskManagement");
            String deleteValue = (String)parser.getOptionValue(this.delete);
            String detailValue = (String)parser.getOptionValue(this.details);
            if (null != parser.getOptionValue(this.list)) {
                System.out.println(oxtask.getJobList(ctx, auth));
            } else if (null != deleteValue) {
                oxtask.deleteJob(ctx, auth, Integer.parseInt(deleteValue));
                System.out.println("Deleted job with ID" + deleteValue);
            } else if (null != detailValue) {
                try {
                    oxtask.getTaskResults(ctx, auth, Integer.parseInt(detailValue));
                }
                catch (InterruptedException e) {
                    System.err.println("This job was interrupted with the following exception: ");
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    System.err.println("The execution of this job was aborted by the following exception: ");
                    e.getCause().printStackTrace();
                }
            } else if (null != parser.getOptionValue(this.flush)) {
                oxtask.flush(ctx, auth);
                System.out.println("All finished jobs flushed.");
            } else {
                System.err.println(new StringBuilder("No option selected (").append(OPT_LIST_LONG).append(", ").append(OPT_DELETE_LONG).append(", ").append(OPT_DETAILS_LONG).append(", ").append(OPT_FLUSH_LONG).append(")"));
                parser.printUsage();
            }
        }
        catch (ConnectException neti) {
            this.printError(neti.getMessage(), parser);
            this.sysexit(105);
        }
        catch (NumberFormatException num) {
            this.printInvalidInputMsg("Ids must be numbers!");
            this.sysexit(1);
        }
        catch (MalformedURLException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (RemoteException e) {
            this.printServerException(e, parser);
            this.sysexit(107);
        }
        catch (NotBoundException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
        catch (CLIParseException e) {
            this.printError("Parsing command-line failed : " + e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(109);
        }
        catch (CLIIllegalOptionValueException e) {
            this.printError("Illegal option value : " + e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(109);
        }
        catch (CLIUnknownOptionException e) {
            this.printError("Unrecognized options on the command line: " + e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(111);
        }
        catch (MissingOptionException e) {
            this.printError(e.getMessage(), parser);
            parser.printUsage();
            this.sysexit(104);
        }
        catch (InvalidDataException e) {
            this.printServerException(e, parser);
            this.sysexit(103);
        }
        catch (InvalidCredentialsException e) {
            this.printServerException(e, parser);
            this.sysexit(101);
        }
        catch (StorageException e) {
            this.printServerException(e, parser);
            this.sysexit(106);
        }
        catch (TaskManagerException e) {
            this.printServerException(e, parser);
            this.sysexit(1);
        }
    }

    private void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptions(parser);
        this.list = this.setShortLongOpt(parser, 'l', OPT_LIST_LONG, "list the jobs of this open-xchange server", false, AdminParser.NeededQuadState.notneeded);
        this.delete = this.setShortLongOpt(parser, 'd', OPT_DELETE_LONG, "id", "delete the the given job id", false);
        this.details = this.setShortLongOpt(parser, 't', OPT_DETAILS_LONG, "id", "show details for the given job", false);
        this.flush = this.setShortLongOpt(parser, 'f', OPT_FLUSH_LONG, "flush all finished jobs from the queue", false, AdminParser.NeededQuadState.notneeded);
    }
}

