/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.context;

import au.com.bytecode.opencsv.CSVReader;
import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.context.ContextAbstraction;
import com.openexchange.admin.console.context.extensioninterfaces.ContextConsoleCreateInterface;
import com.openexchange.admin.console.exception.OXConsolePluginException;
import com.openexchange.admin.console.user.UserAbstraction;
import com.openexchange.admin.rmi.OXLoginInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.admin.rmi.dataobjects.UserModuleAccess;
import com.openexchange.admin.rmi.exceptions.ContextExistsException;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.ParseException;

public abstract class CreateCore
extends ContextAbstraction {
    protected void setOptions(AdminParser parser) {
        this.setCsvImport(parser);
        this.setDefaultCommandLineOptions(parser);
        this.setContextNameOption(parser, AdminParser.NeededQuadState.notneeded);
        this.setMandatoryOptions(parser);
        this.setLanguageOption(parser);
        this.setTimezoneOption(parser);
        this.setContextQuotaOption(parser, true);
        this.setFurtherOptions(parser);
    }

    protected final void commonfunctions(AdminParser parser, String[] args) {
        this.setOptions(parser);
        this.setExtensionOptions(parser, ContextConsoleCreateInterface.class);
        try {
            Context ctx = null;
            Credentials auth = null;
            User usr = null;
            try {
                String languageoptionvalue;
                parser.ownparse(args);
                ctx = this.contextparsing(parser);
                this.parseAndSetContextName(parser, ctx);
                auth = this.credentialsparsing(parser);
                usr = new User();
                this.parseAndSetMandatoryOptionsinUser(parser, usr);
                String tz = (String)parser.getOptionValue(this.timezoneOption);
                if (null != tz) {
                    usr.setTimezone(tz);
                }
                if ((languageoptionvalue = (String)parser.getOptionValue(this.languageOption)) != null) {
                    usr.setLanguage(languageoptionvalue);
                }
                this.parseAndSetContextQuota(parser, ctx);
                this.parseAndSetExtensions(parser, ctx, auth);
            }
            catch (RuntimeException e) {
                this.printError(null, null, e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
            String filename = (String)parser.getOptionValue(parser.getCsvImportOption());
            if (null != filename) {
                this.csvparsing(filename, auth);
            } else {
                this.ctxid = this.maincall(parser, ctx, usr, auth).getId();
            }
        }
        catch (Exception e) {
            this.printErrors(null != this.ctxid ? String.valueOf(this.ctxid) : null, null, e, parser);
        }
        try {
            this.displayCreatedMessage(null != this.ctxid ? String.valueOf(this.ctxid) : null, null, parser);
        }
        catch (RuntimeException e) {
            this.printError(null, null, e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
        this.sysexit(0);
    }

    protected void csvparsing(String filename, Credentials auth) throws NotBoundException, IOException, InvalidDataException, StorageException, InvalidCredentialsException {
        String[] nextLine;
        OXLoginInterface oxlgn = (OXLoginInterface)Naming.lookup(RMI_HOSTNAME + "OXLogin_V2");
        oxlgn.login(auth);
        CSVReader reader = new CSVReader((Reader)new FileReader(filename), ',', '\"');
        int[] idarray = this.csvParsingCommon(filename, reader);
        int linenumber = 2;
        this.lookupRMI();
        while ((nextLine = reader.readNext()) != null) {
            try {
                Context context = this.getContext(nextLine, idarray);
                try {
                    UserModuleAccess moduleacess;
                    this.applyExtensionValuesFromCSV(nextLine, idarray, context);
                    User adminuser = CreateCore.getUser(nextLine, idarray);
                    int i = idarray[UserAbstraction.AccessCombinations.ACCESS_COMBI_NAME.getIndex()];
                    Context createdCtx = -1 != i ? this.simpleMainCall(context, adminuser, nextLine[i], auth) : (!NO_RIGHTS_ACCESS.equals(moduleacess = CreateCore.getUserModuleAccess(nextLine, idarray)) ? this.simpleMainCall(context, adminuser, moduleacess, auth) : this.simpleMainCall(context, adminuser, auth));
                    System.out.println("Context " + createdCtx.getId() + " successfully created");
                }
                catch (OXConsolePluginException e1) {
                    System.err.println("Failed to create context: Error while processing extension options: " + e1.getClass().getSimpleName() + ": " + e1.getMessage());
                }
                catch (StorageException e) {
                    System.err.println("Failed to create context " + this.getContextIdOrLine(context, linenumber) + ": " + e);
                }
                catch (RemoteException e) {
                    System.err.println("Failed to create context " + this.getContextIdOrLine(context, linenumber) + ": " + e);
                }
                catch (InvalidCredentialsException e) {
                    System.err.println("Failed to create context " + this.getContextIdOrLine(context, linenumber) + ": " + e);
                }
                catch (InvalidDataException e) {
                    System.err.println("Failed to create context " + this.getContextIdOrLine(context, linenumber) + ": " + e);
                }
                catch (ContextExistsException e) {
                    System.err.println("Failed to create context " + this.getContextIdOrLine(context, linenumber) + ": " + e);
                }
                catch (ParseException e) {
                    System.err.println("Failed to create context " + this.getContextIdOrLine(context, linenumber) + ": " + e);
                }
            }
            catch (ParseException e2) {
                System.err.println("Failed to create context in line " + linenumber + ": " + e2);
            }
            ++linenumber;
        }
    }

    protected abstract void lookupRMI() throws MalformedURLException, RemoteException, NotBoundException;

    protected void prepareConstantsMap() {
        super.prepareConstantsMap();
        for (ContextAbstraction.ContextConstants value : ContextAbstraction.ContextConstants.values()) {
            this.constantsMap.put(value.getString(), value);
        }
        this.extensionConstantProcessing(this.constantsMap);
    }

    private String getContextIdOrLine(Context context, int linenumber) {
        Integer id = context.getId();
        if (null != id) {
            return id.toString();
        }
        return "in line " + linenumber;
    }

    protected abstract Context simpleMainCall(Context var1, User var2, String var3, Credentials var4) throws RemoteException, StorageException, InvalidCredentialsException, InvalidDataException, ContextExistsException;

    protected abstract Context simpleMainCall(Context var1, User var2, UserModuleAccess var3, Credentials var4) throws RemoteException, StorageException, InvalidCredentialsException, InvalidDataException, ContextExistsException;

    protected abstract Context simpleMainCall(Context var1, User var2, Credentials var3) throws RemoteException, StorageException, InvalidCredentialsException, InvalidDataException, ContextExistsException;

    protected abstract Context maincall(AdminParser var1, Context var2, User var3, Credentials var4) throws RemoteException, StorageException, InvalidCredentialsException, InvalidDataException, MalformedURLException, NotBoundException, ContextExistsException, NoSuchContextException;

    protected abstract void setFurtherOptions(AdminParser var1);

    public void checkRequired(int[] idarray) throws InvalidDataException {
        super.checkRequired(idarray);
        for (ContextAbstraction.ContextConstants value : ContextAbstraction.ContextConstants.values()) {
            if (!value.isRequired() || -1 != idarray[value.getIndex()]) continue;
            throw new InvalidDataException("The required column \"" + value.getString() + "\" is missing");
        }
    }
}

