/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.BasicCommandlineOptions;
import com.openexchange.admin.console.CLIIllegalOptionValueException;
import com.openexchange.admin.console.CLIParseException;
import com.openexchange.admin.console.CLIUnknownOptionException;
import com.openexchange.admin.rmi.exceptions.ContextExistsException;
import com.openexchange.admin.rmi.exceptions.DatabaseUpdateException;
import com.openexchange.admin.rmi.exceptions.DuplicateExtensionException;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.MissingOptionException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.NoSuchGroupException;
import com.openexchange.admin.rmi.exceptions.NoSuchResourceException;
import com.openexchange.admin.rmi.exceptions.NoSuchUserException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public abstract class ObjectNamingAbstraction
extends BasicCommandlineOptions {
    protected abstract String getObjectName();

    protected final void displayCreatedMessage(String id, Integer ctxid, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, "created", parser);
    }

    protected final void displayChangedMessage(String id, Integer ctxid, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, "changed", parser);
    }

    protected final void displayDeletedMessage(String id, Integer ctxid, AdminParser parser) {
        this.createMessageForStdout(id, ctxid, "deleted", parser);
    }

    protected void createMessageForStdout(String id, Integer ctxid, String type, AdminParser parser) {
        this.createMessage(id, ctxid, type, System.out, parser, false);
    }

    private void createMessage(String id, Integer ctxid, String type, PrintStream ps, AdminParser parser, boolean followingtext) {
        StringBuilder sb = new StringBuilder(this.getObjectName());
        if (null != id) {
            sb.append(" ");
            sb.append(id);
        }
        if (null != ctxid) {
            sb.append(" in context ");
            sb.append(ctxid);
        }
        sb.append(" ");
        sb.append(type);
        if (null != parser && parser.checkNoNewLine()) {
            String output = sb.toString().replace("\n", "");
            if (followingtext) {
                ps.print(output);
            } else {
                ps.println(output);
            }
        } else {
            ps.println(sb.toString());
        }
    }

    protected void createMessageForStderr(String id, Integer ctxid, String type, AdminParser parser) {
        this.createMessage(id, ctxid, type, System.err, parser, true);
    }

    protected final void printError(String id, Integer ctxid, String msg, AdminParser parser) {
        this.printFirstPartOfErrorText(id, ctxid, parser);
        this.printError(msg, parser);
    }

    protected final void printInvalidInputMsg(String id, Integer ctxid, String msg, AdminParser parser) {
        this.printFirstPartOfErrorText(id, ctxid, parser);
        this.printInvalidInputMsg(msg);
    }

    protected void printServerException(String id, Integer ctxid, Exception e, AdminParser parser) {
        this.printFirstPartOfErrorText(id, ctxid, parser);
        this.printServerException(e, parser);
    }

    protected final void printNotBoundResponse(Integer id, Integer ctxid, NotBoundException nbe) {
        System.err.println("RMI module " + nbe.getMessage() + " not available on server");
    }

    protected void printFirstPartOfErrorText(String id, Integer ctxid, AdminParser parser) {
        if (this.getClass().getName().matches("^.*\\.\\w*(?i)create\\w*$")) {
            this.createMessageForStderr(id, ctxid, "could not be created: ", parser);
        } else if (this.getClass().getName().matches("^.*\\.\\w*(?i)change\\w*$")) {
            this.createMessageForStderr(id, ctxid, "could not be changed: ", parser);
        } else if (this.getClass().getName().matches("^.*\\.\\w*(?i)delete\\w*$")) {
            this.createMessageForStderr(id, ctxid, "could not be deleted: ", parser);
        } else if (this.getClass().getName().matches("^.*\\.\\w*(?i)list\\w*$")) {
            this.createMessageForStderr(id, ctxid, "could not be listed: ", parser);
        }
    }

    protected void printErrors(String id, Integer ctxid, Exception e, AdminParser parser) {
        if (e instanceof ConnectException) {
            ConnectException new_name = (ConnectException)e;
            this.printError(id, ctxid, new_name.getMessage(), parser);
            this.sysexit(105);
        } else if (e instanceof NumberFormatException) {
            this.printInvalidInputMsg(id, ctxid, "Ids must be numbers!", parser);
            this.sysexit(1);
        } else if (e instanceof MalformedURLException) {
            MalformedURLException exc = (MalformedURLException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof RemoteException) {
            RemoteException exc = (RemoteException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(107);
        } else if (e instanceof NotBoundException) {
            NotBoundException exc = (NotBoundException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof InvalidCredentialsException) {
            InvalidCredentialsException exc = (InvalidCredentialsException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(101);
        } else if (e instanceof NoSuchContextException) {
            NoSuchContextException exc = (NoSuchContextException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(102);
        } else if (e instanceof InvocationTargetException) {
            this.printError(id, ctxid, e.getMessage(), parser);
            this.sysexit(1);
        } else if (e instanceof StorageException) {
            StorageException exc = (StorageException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(106);
        } else if (e instanceof InvalidDataException) {
            InvalidDataException exc = (InvalidDataException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(103);
        } else if (e instanceof IllegalArgumentException) {
            this.printError(id, ctxid, e.getMessage(), parser);
            this.sysexit(1);
        } else if (e instanceof IllegalAccessException) {
            this.printError(id, ctxid, e.getMessage(), parser);
            this.sysexit(1);
        } else if (e instanceof CLIParseException) {
            CLIParseException exc = (CLIParseException)e;
            this.printError(id, ctxid, "Failed parsing command line: " + exc.getMessage(), parser);
            parser.printUsage();
            this.sysexit(109);
        } else if (e instanceof CLIIllegalOptionValueException) {
            CLIIllegalOptionValueException exc = (CLIIllegalOptionValueException)e;
            this.printError(id, ctxid, "Illegal option value : " + exc.getMessage(), parser);
            parser.printUsage();
            this.sysexit(109);
        } else if (e instanceof CLIUnknownOptionException) {
            CLIUnknownOptionException exc = (CLIUnknownOptionException)e;
            this.printError(id, ctxid, "Unrecognized options on the command line: " + exc.getMessage(), parser);
            parser.printUsage();
            this.sysexit(111);
        } else if (e instanceof MissingOptionException) {
            MissingOptionException missing = (MissingOptionException)e;
            this.printError(id, ctxid, missing.getMessage(), parser);
            parser.printUsage();
            this.sysexit(104);
        } else if (e instanceof DatabaseUpdateException) {
            DatabaseUpdateException exc = (DatabaseUpdateException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof NoSuchUserException) {
            NoSuchUserException exc = (NoSuchUserException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(108);
        } else if (e instanceof NoSuchGroupException) {
            NoSuchGroupException exc = (NoSuchGroupException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(112);
        } else if (e instanceof NoSuchResourceException) {
            this.printServerException(id, ctxid, e, parser);
            this.sysexit(113);
        } else if (e instanceof DuplicateExtensionException) {
            DuplicateExtensionException exc = (DuplicateExtensionException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof ContextExistsException) {
            ContextExistsException exc = (ContextExistsException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof URISyntaxException) {
            URISyntaxException exc = (URISyntaxException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else if (e instanceof RuntimeException) {
            RuntimeException exc = (RuntimeException)e;
            this.printServerException(id, ctxid, exc, parser);
            this.sysexit(1);
        } else {
            this.printServerException(id, ctxid, e, parser);
            this.sysexit(1);
        }
    }
}

