/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.ExtendableDataObject;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.MissingOptionException;
import com.openexchange.admin.rmi.extensions.OXCommonExtension;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicCommandlineOptions {
    private static final char dividechar = ' ';
    public static final int SYSEXIT_INVALID_CREDENTIALS = 101;
    public static final int SYSEXIT_NO_SUCH_CONTEXT = 102;
    public static final int SYSEXIT_INVALID_DATA = 103;
    public static final int SYSEXIT_MISSING_OPTION = 104;
    public static final int SYSEXIT_COMMUNICATION_ERROR = 105;
    public static final int SYSEXIT_SERVERSTORAGE_ERROR = 106;
    public static final int SYSEXIT_REMOTE_ERROR = 107;
    public static final int SYSEXIT_NO_SUCH_USER = 108;
    public static final int SYSEXIT_ILLEGAL_OPTION_VALUE = 109;
    public static final int SYSEXIT_CONTEXT_ALREADY_EXISTS = 110;
    public static final int SYSEXIT_UNKNOWN_OPTION = 111;
    public static final int SYSEXIT_NO_SUCH_GROUP = 112;
    public static final int SYSEXIT_NO_SUCH_RESOURCE = 113;
    public static final int SYSEXIT_UNABLE_TO_PARSE = 114;
    protected static final int DEFAULT_CONTEXT = 1;
    protected static final char OPT_NAME_CONTEXT_SHORT = 'c';
    protected static final String OPT_NAME_CONTEXT_LONG = "contextid";
    protected static final char OPT_NAME_CONTEXT_NAME_SHORT = 'N';
    protected static final String OPT_NAME_CONTEXT_NAME_LONG = "contextname";
    protected static final String OPT_NAME_CONTEXT_NAME_DESCRIPTION = "context name";
    protected static final String OPT_NAME_CONTEXT_DESCRIPTION = "The id of the context";
    protected static final char OPT_NAME_ADMINUSER_SHORT = 'A';
    protected static final String OPT_NAME_ADMINUSER_LONG = "adminuser";
    protected static final char OPT_NAME_ADMINPASS_SHORT = 'P';
    protected static final String OPT_NAME_ADMINPASS_LONG = "adminpass";
    protected static final String OPT_NAME_ADMINPASS_DESCRIPTION = "Admin password";
    protected static final String OPT_NAME_ADMINUSER_DESCRIPTION = "Admin username";
    protected static final String OPT_NAME_SEARCHPATTERN_LONG = "searchpattern";
    protected static final char OPT_NAME_SEARCHPATTERN = 's';
    protected static final String OPT_NAME_CSVOUTPUT_LONG = "csv";
    protected static final String OPT_NAME_CSVOUTPUT_DESCRIPTION = "Format output to csv";
    private static final String[] ENV_OPTIONS = new String[]{"RMI_HOSTNAME", "COMMANDLINE_TIMEZONE", "COMMANDLINE_DATEFORMAT", "ADMIN_PASSWORD", "NEW_USER_PASSWORD"};
    protected static String RMI_HOSTNAME = "rmi://localhost:1099/";
    protected static String COMMANDLINE_TIMEZONE = "GMT";
    protected static String COMMANDLINE_DATEFORMAT = "yyyy-MM-dd";
    protected static String ADMIN_PASSWORD = null;
    protected static String NEW_USER_PASSWORD = null;
    protected CLIOption contextOption = null;
    protected CLIOption contextNameOption = null;
    protected CLIOption adminUserOption = null;
    protected CLIOption adminPassOption = null;
    protected CLIOption searchOption = null;
    protected CLIOption csvOutputOption = null;
    protected Integer ctxid = null;

    public BasicCommandlineOptions() {
        for (String opt : ENV_OPTIONS) {
            this.setEnvConfigOption(opt);
        }
    }

    public static final Hashtable<String, String> getEnvOptions() {
        Hashtable<String, String> opts = new Hashtable<String, String>();
        for (String opt : ENV_OPTIONS) {
            try {
                Field f = BasicCommandlineOptions.class.getDeclaredField(opt);
                String val = (String)f.get(null);
                if (val == null) {
                    val = "<NOT SET>";
                }
                opts.put(opt, val);
            }
            catch (SecurityException e) {
                System.err.println("unable to get commandline option \"" + opt + "\"");
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                System.err.println("unable to get commandline option \"" + opt + "\"");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                System.err.println("unable to get commandline option \"" + opt + "\"");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("unable to get commandline option \"" + opt + "\"");
                e.printStackTrace();
            }
        }
        return opts;
    }

    private final void setEnvConfigOption(String opt) {
        String property = System.getProperties().getProperty(opt);
        String env = System.getenv(opt);
        String setOpt = null;
        if (null != env && env.trim().length() > 0) {
            setOpt = env;
        } else if (null != property && property.trim().length() > 0) {
            setOpt = property;
        }
        if (setOpt != null) {
            if (opt.equals("RMI_HOSTNAME")) {
                this.setRMI_HOSTNAME(setOpt);
            } else {
                try {
                    Field f = BasicCommandlineOptions.class.getDeclaredField(opt);
                    f.set(this, setOpt);
                }
                catch (SecurityException e) {
                    System.err.println("unable to set commandline option for \"" + opt + "\" to \"" + setOpt + "\"");
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    System.err.println("unable to set commandline option for \"" + opt + "\" to \"" + setOpt + "\"");
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    System.err.println("unable to set commandline option for \"" + opt + "\" to \"" + setOpt + "\"");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    System.err.println("unable to set commandline option for \"" + opt + "\" to \"" + setOpt + "\"");
                    e.printStackTrace();
                }
            }
        }
    }

    protected final void printServerException(Exception e, AdminParser parser) {
        String output = "";
        String msg = e.getMessage();
        if (parser != null && parser.checkNoNewLine()) {
            if (msg != null) {
                output = "Server response: " + msg.replace("\n", "");
            } else {
                output = output + e.toString();
                for (StackTraceElement ste : e.getStackTrace()) {
                    output = output + ": " + ste.toString().replace("\n", "");
                }
            }
        } else if (msg != null) {
            output = "Server response:\n " + msg;
        } else {
            output = output + e.toString() + "\n";
            for (StackTraceElement ste : e.getStackTrace()) {
                output = output + "\tat " + ste.toString() + "\n";
            }
        }
        System.err.println(output);
    }

    protected final void printError(String msg, AdminParser parser) {
        String output = null;
        output = parser == null ? msg : (parser.checkNoNewLine() ? msg.replace("\n", "") : msg);
        System.err.println("Error: " + output);
    }

    protected final void printServerResponse(String msg) {
        System.err.println("Server response:\n " + msg + "\n");
    }

    protected final void printInvalidInputMsg(String msg) {
        System.err.println("Invalid input detected: " + msg);
    }

    protected final void doCSVOutput(ArrayList<String> columns, ArrayList<ArrayList<String>> data) throws InvalidDataException {
        StringBuilder sb = new StringBuilder();
        for (String string : columns) {
            sb.append(string);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        System.out.println(sb.toString());
        if (columns != null && data != null && !data.isEmpty()) {
            if (columns.size() != data.get(0).size()) {
                throw new InvalidDataException("Number of columnnames and number of columns in data object must be the same");
            }
            for (ArrayList arrayList : data) {
                sb = new StringBuilder();
                for (String data_column : arrayList) {
                    if (data_column != null) {
                        sb.append("\"");
                        sb.append(data_column.replaceAll("\"", "\"\""));
                        sb.append("\"");
                    }
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                System.out.println(sb.toString());
            }
        }
    }

    protected final void setRMI_HOSTNAME(String rmi_hostname) {
        String host = rmi_hostname;
        if (!host.startsWith("rmi://")) {
            host = "rmi://" + host;
        }
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        RMI_HOSTNAME = host;
    }

    protected final CLIOption setLongOpt(AdminParser admp, String longopt, String description, boolean hasarg, boolean required) {
        CLIOption retval = admp.addOption(longopt, longopt, description, required, hasarg);
        return retval;
    }

    protected final CLIOption setLongOpt(AdminParser admp, String longopt, String description, boolean hasarg, boolean required, boolean extended) {
        CLIOption retval = admp.addOption(longopt, longopt, description, required, hasarg, extended);
        return retval;
    }

    protected final CLIOption setLongOpt(AdminParser admp, String longopt, String argdescription, String description, boolean hasarg, boolean required, boolean extended) {
        CLIOption retval = admp.addOption(longopt, argdescription, description, required, hasarg, extended);
        return retval;
    }

    protected final CLIOption setIntegerLongOpt(AdminParser admp, String longopt, String argdescription, String description, boolean hasarg, boolean required, boolean extended) {
        CLIOption retval = admp.addIntegerOption(longopt, argdescription, description, required, hasarg, extended);
        return retval;
    }

    protected final CLIOption setSettableBooleanLongOpt(AdminParser admp, String longopt, String argdescription, String description, boolean hasarg, boolean required, boolean extended) {
        CLIOption retval = admp.addSettableBooleanOption(longopt, argdescription, description, required, hasarg, extended);
        return retval;
    }

    protected final CLIOption setShortLongOpt(AdminParser admp, char shortopt, String longopt, String argdescription, String description, boolean required) {
        CLIOption retval = admp.addOption(shortopt, longopt, argdescription, description, required);
        return retval;
    }

    protected final CLIOption setShortLongOpt(AdminParser admp, char shortopt, String longopt, String description, boolean hasarg, AdminParser.NeededQuadState required) {
        CLIOption retval = admp.addOption(shortopt, longopt, longopt, description, required, hasarg);
        return retval;
    }

    protected final CLIOption setShortLongOptWithDefault(AdminParser admp, char shortopt, String longopt, String description, String defaultvalue, boolean hasarg, AdminParser.NeededQuadState required) {
        StringBuilder desc = new StringBuilder();
        desc.append(description);
        desc.append(". Default: ");
        desc.append(defaultvalue);
        return this.setShortLongOpt(admp, shortopt, longopt, desc.toString(), hasarg, required);
    }

    protected final CLIOption setShortLongOptWithDefault(AdminParser admp, char shortopt, String longopt, String argdescription, String description, String defaultvalue, boolean required) {
        StringBuilder desc = new StringBuilder();
        desc.append(description);
        desc.append(". Default: ");
        desc.append(defaultvalue);
        return this.setShortLongOpt(admp, shortopt, longopt, argdescription, desc.toString(), required);
    }

    protected final void setContextOption(AdminParser admp, AdminParser.NeededQuadState needed) {
        this.contextOption = this.setShortLongOpt(admp, 'c', OPT_NAME_CONTEXT_LONG, OPT_NAME_CONTEXT_DESCRIPTION, true, needed);
    }

    protected final void setContextNameOption(AdminParser admp, AdminParser.NeededQuadState needed) {
        this.contextNameOption = this.setShortLongOpt(admp, 'N', OPT_NAME_CONTEXT_NAME_LONG, OPT_NAME_CONTEXT_NAME_DESCRIPTION, true, needed);
    }

    protected void setAdminPassOption(AdminParser admp) {
        this.adminPassOption = this.setShortLongOpt(admp, 'P', OPT_NAME_ADMINPASS_LONG, OPT_NAME_ADMINPASS_DESCRIPTION, true, AdminParser.NeededQuadState.possibly);
    }

    protected final void setCSVOutputOption(AdminParser admp) {
        this.csvOutputOption = this.setLongOpt(admp, OPT_NAME_CSVOUTPUT_LONG, OPT_NAME_CSVOUTPUT_DESCRIPTION, false, false);
    }

    protected void setAdminUserOption(AdminParser admp) {
        this.adminUserOption = this.setShortLongOpt(admp, 'A', OPT_NAME_ADMINUSER_LONG, OPT_NAME_ADMINUSER_DESCRIPTION, true, AdminParser.NeededQuadState.possibly);
    }

    protected final void setSearchPatternOption(AdminParser admp) {
        this.searchOption = this.setShortLongOpt(admp, 's', OPT_NAME_SEARCHPATTERN_LONG, "The search pattern which is used for listing", true, AdminParser.NeededQuadState.notneeded);
    }

    @Deprecated
    protected final CLIOption addDefaultArgName(AdminParser admp, CLIOption option) {
        return null;
    }

    protected final int testStringAndGetIntOrDefault(String test, int defaultvalue) throws NumberFormatException {
        if (null != test) {
            return Integer.parseInt(test);
        }
        return defaultvalue;
    }

    protected final String testStringAndGetStringOrDefault(String test, String defaultvalue) {
        if (null != test) {
            return test;
        }
        return defaultvalue;
    }

    protected final boolean testStringAndGetBooleanOrDefault(String test, boolean defaultvalue) {
        if (null != test) {
            return Boolean.parseBoolean(test);
        }
        return defaultvalue;
    }

    protected void setDefaultCommandLineOptions(AdminParser admp) {
        this.setContextOption(admp, AdminParser.NeededQuadState.needed);
        this.setAdminUserOption(admp);
        this.setAdminPassOption(admp);
    }

    protected final void setDefaultCommandLineOptionsWithoutContextID(AdminParser parser) {
        this.setAdminUserOption(parser);
        this.setAdminPassOption(parser);
    }

    protected void sysexit(int exitcode) {
        System.gc();
        System.runFinalization();
        System.exit(exitcode);
    }

    protected final Context contextparsing(AdminParser parser) {
        Context ctx = new Context();
        if (parser.getOptionValue(this.contextOption) != null) {
            this.ctxid = Integer.parseInt((String)parser.getOptionValue(this.contextOption));
            ctx.setId(this.ctxid);
        }
        return ctx;
    }

    protected final Credentials credentialsparsing(AdminParser parser) {
        String password = (String)parser.getOptionValue(this.adminPassOption);
        if (null == password && null != ADMIN_PASSWORD) {
            password = ADMIN_PASSWORD;
        }
        return new Credentials((String)parser.getOptionValue(this.adminUserOption), password);
    }

    private String stripString(String text, int length, String lastmark) {
        if (null != text && text.length() > length) {
            int stringlength = length - lastmark.length();
            return new StringBuffer(text.substring(0, stringlength)).append(lastmark).toString();
        }
        if (text == null) {
            return "";
        }
        return text;
    }

    protected String getObjectsAsString(Object[] objects) {
        StringBuilder sb = new StringBuilder();
        if (objects != null && objects.length > 0) {
            for (Object id : objects) {
                sb.append(id);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return "";
    }

    private final int longestLine(ArrayList<ArrayList<String>> data, String[] columnnames, int column) throws InvalidDataException {
        int max = columnnames[column].length();
        for (int row = 0; row < data.size(); ++row) {
            int curLength;
            ArrayList<String> arrayList = data.get(row);
            if (columnnames.length != arrayList.size()) {
                throw new InvalidDataException("The sizes of columnnames and the columns in line " + row + " of the data aren't equal");
            }
            String value = arrayList.get(column);
            if (value == null || (curLength = arrayList.get(column).length()) <= max) continue;
            max = curLength;
        }
        return max;
    }

    protected void doOutput(String[] columnsizesandalignments, String[] columnnames, ArrayList<ArrayList<String>> data) throws InvalidDataException {
        if (columnsizesandalignments.length != columnnames.length) {
            throw new InvalidDataException("The sizes of columnsizes and columnnames aren't equal");
        }
        int[] columnsizes = new int[columnsizesandalignments.length];
        char[] alignments = new char[columnsizesandalignments.length];
        StringBuilder formatsb = new StringBuilder();
        for (int i = 0; i < columnsizesandalignments.length; ++i) {
            try {
                columnsizes[i] = Integer.parseInt(columnsizesandalignments[i].substring(0, columnsizesandalignments[i].length() - 1));
            }
            catch (NumberFormatException e) {
                columnsizes[i] = this.longestLine(data, columnnames, i);
            }
            alignments[i] = columnsizesandalignments[i].charAt(columnsizesandalignments[i].length() - 1);
            if (columnnames[i].length() > columnsizes[i]) {
                throw new InvalidDataException("Columnsize for column " + columnnames[i] + " is too small for columnname");
            }
            formatsb.append("%");
            if (alignments[i] == 'l') {
                formatsb.append('-');
            }
            formatsb.append(columnsizes[i]);
            formatsb.append('s');
            formatsb.append(' ');
        }
        formatsb.deleteCharAt(formatsb.length() - 1);
        formatsb.append('\n');
        System.out.format(formatsb.toString(), columnnames);
        for (ArrayList<String> row : data) {
            if (row.size() != columnsizesandalignments.length) {
                throw new InvalidDataException("The size of one of the rows isn't correct");
            }
            Object[] outputrow = new Object[columnsizesandalignments.length];
            for (int i = 0; i < columnsizesandalignments.length; ++i) {
                String value = row.get(i);
                outputrow[i] = this.stripString(value, columnsizes[i], "~");
            }
            System.out.format(formatsb.toString(), outputrow);
        }
    }

    protected final void printExtensionsError(ExtendableDataObject obj) {
        if (obj != null && obj.getAllExtensionsAsHash() != null) {
            for (OXCommonExtension obj_extension : obj.getAllExtensionsAsHash().values()) {
                if (obj_extension.getExtensionError() == null) continue;
                this.printServerResponse(obj_extension.getExtensionError());
            }
        }
    }

    protected final AdminParser.NeededQuadState convertBooleantoTriState(boolean needed) {
        return needed ? AdminParser.NeededQuadState.needed : AdminParser.NeededQuadState.notneeded;
    }

    protected String nameOrIdSetInt(Integer id, String name, String objectname) throws MissingOptionException {
        if (null == id) {
            return this.nameOrIdSet(null, name, objectname);
        }
        return this.nameOrIdSet(String.valueOf(id), name, objectname);
    }

    protected String nameOrIdSet(String id, String name, String objectname) throws MissingOptionException {
        String successtext;
        if (null == id) {
            if (null == name) {
                throw new MissingOptionException("Either " + objectname + "name or " + objectname + "id must be given");
            }
            successtext = name;
        } else {
            successtext = String.valueOf(id);
        }
        return successtext;
    }
}

