/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.util.server;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.util.server.ServerAbstraction;
import com.openexchange.admin.rmi.OXUtilInterface;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Server;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.rmi.Naming;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListServer
extends ServerAbstraction {
    public ListServer(String[] args2) {
        AdminParser parser = new AdminParser("listserver");
        this.setOptions(parser);
        this.setCSVOutputOption(parser);
        try {
            parser.ownparse(args2);
            Credentials auth = this.credentialsparsing(parser);
            OXUtilInterface oxutil = (OXUtilInterface)Naming.lookup(RMI_HOSTNAME + "OXUtil_V2");
            String searchpattern = "*";
            if (parser.getOptionValue(this.searchOption) != null) {
                searchpattern = (String)parser.getOptionValue(this.searchOption);
            }
            Server[] servers = oxutil.listServer(searchpattern, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(servers);
            } else {
                this.sysoutOutput(servers);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, null, e, parser);
        }
    }

    public static void main(String[] args) {
        new ListServer(args);
    }

    private void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setSearchOption(parser);
    }

    private void sysoutOutput(Server[] servers) throws InvalidDataException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Server server : servers) {
            data.add(this.makeCSVData(server));
        }
        this.doOutput(new String[]{"r", "l"}, new String[]{"Id", "Name"}, data);
    }

    private void precsvinfos(Server[] servers) throws InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("name");
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Server server : servers) {
            data.add(this.makeCSVData(server));
        }
        this.doCSVOutput(columns, data);
    }

    private ArrayList<String> makeCSVData(Server server) {
        ArrayList<String> srv_data = new ArrayList<String>();
        srv_data.add(String.valueOf(server.getId()));
        String servername = server.getName();
        if (servername != null) {
            srv_data.add(servername);
        } else {
            srv_data.add(null);
        }
        return srv_data;
    }

    @Override
    protected final String getObjectName() {
        return "servers";
    }
}

