/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.util.reason;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.util.reason.ReasonAbstraction;
import com.openexchange.admin.rmi.OXUtilInterface;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.MaintenanceReason;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.rmi.Naming;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListReason
extends ReasonAbstraction {
    public ListReason(String[] args2) {
        AdminParser parser = new AdminParser("listreason");
        this.setOptions(parser);
        this.setCSVOutputOption(parser);
        try {
            parser.ownparse(args2);
            Credentials auth = this.credentialsparsing(parser);
            OXUtilInterface oxutil = (OXUtilInterface)Naming.lookup(RMI_HOSTNAME + "OXUtil_V2");
            String pattern = "*";
            if (parser.getOptionValue(this.searchOption) != null) {
                pattern = (String)parser.getOptionValue(this.searchOption);
            }
            MaintenanceReason[] mrs = oxutil.listMaintenanceReason(pattern, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(mrs);
            } else {
                this.sysoutOutput(mrs);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, null, e, parser);
        }
    }

    public static void main(String[] args) {
        new ListReason(args);
    }

    private void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setSearchOption(parser);
    }

    private void sysoutOutput(MaintenanceReason[] mrs) throws InvalidDataException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (MaintenanceReason mr : mrs) {
            data.add(this.makeCSVData(mr));
        }
        this.doOutput(new String[]{"r", "l"}, new String[]{"Id", "Text"}, data);
    }

    private void precsvinfos(MaintenanceReason[] mrs) throws InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("text");
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (MaintenanceReason mr : mrs) {
            data.add(this.makeCSVData(mr));
        }
        this.doCSVOutput(columns, data);
    }

    private ArrayList<String> makeCSVData(MaintenanceReason mr) {
        ArrayList<String> rea_data = new ArrayList<String>();
        rea_data.add(mr.getId().toString());
        rea_data.add(mr.getText());
        return rea_data;
    }

    @Override
    protected final String getObjectName() {
        return "reasons";
    }
}

