/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.util.filestore;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.util.filestore.FilestoreAbstraction;
import com.openexchange.admin.rmi.OXUtilInterface;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Filestore;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.net.URISyntaxException;
import java.rmi.Naming;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFilestore
extends FilestoreAbstraction {
    public ListFilestore(String[] args2) {
        AdminParser parser = new AdminParser("listfilestore");
        this.setOptions(parser);
        this.setCSVOutputOption(parser);
        try {
            parser.ownparse(args2);
            Credentials auth = this.credentialsparsing(parser);
            OXUtilInterface oxutil = (OXUtilInterface)Naming.lookup(RMI_HOSTNAME + "OXUtil_V2");
            String searchpattern = "*";
            if (parser.getOptionValue(this.searchOption) != null) {
                searchpattern = (String)parser.getOptionValue(this.searchOption);
            }
            Filestore[] filestores = oxutil.listFilestore(searchpattern, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(filestores);
            } else {
                this.sysoutOutput(filestores);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, this.ctxid, e, parser);
        }
    }

    private void sysoutOutput(Filestore[] filestores) throws InvalidDataException, URISyntaxException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Filestore filestore : filestores) {
            data.add(this.makeCSVData(filestore, false));
        }
        this.doOutput(new String[]{"r", "l", "r", "r", "r", "r", "r"}, new String[]{"id", "path", "size", "reserved", "used", "maxctx", "curctx"}, data);
    }

    private void precsvinfos(Filestore[] filestores) throws URISyntaxException, InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("uri");
        columns.add("size");
        columns.add("reserved");
        columns.add("used");
        columns.add("maxcontexts");
        columns.add("currentcontexts");
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Filestore filestore : filestores) {
            data.add(this.makeCSVData(filestore, true));
        }
        this.doCSVOutput(columns, data);
    }

    public static void main(String[] args) {
        new ListFilestore(args);
    }

    private void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setSearchOption(parser);
    }

    private ArrayList<String> makeCSVData(Filestore fstore, boolean csv) throws URISyntaxException {
        ArrayList<String> rea_data = new ArrayList<String>();
        rea_data.add(fstore.getId().toString());
        rea_data.add(fstore.getUrl());
        if (fstore.getSize() != null) {
            rea_data.add(fstore.getSize().toString());
        } else {
            rea_data.add(null);
        }
        if (fstore.getReserved() != null) {
            rea_data.add(fstore.getReserved().toString());
        } else {
            rea_data.add(null);
        }
        if (fstore.getUsed() != null) {
            rea_data.add(fstore.getUsed().toString());
        } else {
            rea_data.add(null);
        }
        if (fstore.getMaxContexts() != null) {
            rea_data.add(fstore.getMaxContexts().toString());
        } else {
            rea_data.add(null);
        }
        if (fstore.getCurrentContexts() != null) {
            rea_data.add(fstore.getCurrentContexts().toString());
        } else {
            rea_data.add(null);
        }
        return rea_data;
    }

    @Override
    protected final String getObjectName() {
        return "filestores";
    }
}

