/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.caldav.query;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jdom2.Attribute;
import org.jdom2.Element;
import com.openexchange.caldav.CaldavProtocol;
import com.openexchange.log.LogFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;


/**
 * {@link FilterParser}
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public class FilterParser {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(FilterParser.class);
    
    public Filter parse(Element rootElement) throws WebdavProtocolException {
        Filter filter = new Filter();
        initChildFilters(filter, rootElement);
        return filter;
    }
    
    private static final String DATETIME_PATTERN = "yyyyMMdd'T'HHmmss'Z'";

    private void initChildFilters(Filter filter, Element rootElement) throws WebdavProtocolException {
        List<Element> children = rootElement.getChildren("comp-filter", CaldavProtocol.CAL_NS);
        for (Object cObj : children) {
            Element compFilterElement = (Element) cObj;
            CompFilter compFilter = new CompFilter();
            compFilter.setName(compFilterElement.getAttributeValue("name"));
            initChildFilters(compFilter, compFilterElement);
            filter.addFilter(compFilter);
        }
        
        children = rootElement.getChildren("time-range", CaldavProtocol.CAL_NS);
        for (Object cObj : children) {
            Element timeRangeElement = (Element) cObj;
            TimeRange tr = new TimeRange();

            tr.setStart(parseDate(timeRangeElement.getAttribute("start")));
            tr.setEnd(parseDate(timeRangeElement.getAttribute("end")));

            filter.addFilter(tr);
        }
    }

    private long parseDate(Attribute startAttr) throws WebdavProtocolException {
        SimpleDateFormat format = new SimpleDateFormat(DATETIME_PATTERN);
        format.setTimeZone(TimeZone.getTimeZone("utc"));
        if (startAttr != null && startAttr.getValue() != null) {
            try {
                Date startDate = format.parse(startAttr.getValue());
                return startDate.getTime();
            } catch (ParseException e) {
                LOG.error(e.getMessage(), e);
                throw WebdavProtocolException.generalError(new WebdavPath(), HttpServletResponse.SC_BAD_REQUEST);
            }
        }
        return TimeRange.NOT_SET;
    }
}
