/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.datatypes.genericonf.storage.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import com.openexchange.datatypes.genericonf.IterationBreak;

/**
 * {@link InsertIterator}
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public class InsertIterator implements MapIterator<String, Object> {

    private static final String INSERT_STRING = "INSERT INTO genconf_attributes_strings (id, cid, name, value) VALUES (?,?,?,?)";
    private static final String INSERT_BOOL = "INSERT INTO genconf_attributes_bools (id, cid, name, value) VALUES (?,?,?,?)";


    private SQLException exception;

    private final Map<Class, PreparedStatement> statementMap = new HashMap<Class, PreparedStatement>();

    public void prepareStatements(TX tx) throws SQLException {

        PreparedStatement insertString = tx.prepare(INSERT_STRING);
        PreparedStatement insertBool = tx.prepare(INSERT_BOOL);

        statementMap.put(String.class, insertString);
        statementMap.put(Boolean.class, insertBool);
    }

    public void setIds(int cid, int id) throws SQLException {
        for(PreparedStatement stmt : statementMap.values()) {
            stmt.setInt(1, id);
            stmt.setInt(2, cid);
        }
    }

    @Override
    public void handle(String key, Object value) throws IterationBreak {
        if(exception != null) {
            return;
        }
        if(value == null) {
            return;
        }
        PreparedStatement stmt = statementMap.get(value.getClass());
        if (null == stmt) {
            exception = new SQLException("Unsupported object type: " + value.getClass().getName());
            throw new IterationBreak();
        }

        try {
            stmt.setString(3, key);
            stmt.setObject(4, value);
            stmt.executeUpdate();
        } catch (SQLException e) {
            exception = e;
            throw new IterationBreak();
        }

    }

    public void throwException() throws SQLException {
        if(exception != null) {
            throw exception;
        }
    }

    public void close() {
        Collection<PreparedStatement> statements = statementMap.values();
        for (PreparedStatement preparedStatement : statements) {
            try {
                preparedStatement.close();
            } catch (SQLException x) {
                // Ignore
            }
        }
    }

}
