/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.util.BitField;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public abstract class LFOAbstractType {
    protected int field_1_lsid;
    protected int field_2_reserved1;
    protected int field_3_reserved2;
    protected byte field_4_clfolvl;
    protected byte field_5_ibstFltAutoNum;
    protected byte field_6_grfhic;
    private static BitField fHtmlChecked = new BitField(1);
    private static BitField fHtmlUnsupported = new BitField(2);
    private static BitField fHtmlListTextNotSharpDot = new BitField(4);
    private static BitField fHtmlNotPeriod = new BitField(8);
    private static BitField fHtmlFirstLineMismatch = new BitField(16);
    private static BitField fHtmlTabLeftIndentMismatch = new BitField(32);
    private static BitField fHtmlHangingIndentBeneathNumber = new BitField(64);
    private static BitField fHtmlBuiltInBullet = new BitField(128);
    protected byte field_7_reserved3;

    protected LFOAbstractType() {
    }

    protected void fillFields(byte[] data, int offset) {
        this.field_1_lsid = LittleEndian.getInt(data, 0 + offset);
        this.field_2_reserved1 = LittleEndian.getInt(data, 4 + offset);
        this.field_3_reserved2 = LittleEndian.getInt(data, 8 + offset);
        this.field_4_clfolvl = data[12 + offset];
        this.field_5_ibstFltAutoNum = data[13 + offset];
        this.field_6_grfhic = data[14 + offset];
        this.field_7_reserved3 = data[15 + offset];
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putInt(data, 0 + offset, this.field_1_lsid);
        LittleEndian.putInt(data, 4 + offset, this.field_2_reserved1);
        LittleEndian.putInt(data, 8 + offset, this.field_3_reserved2);
        data[12 + offset] = this.field_4_clfolvl;
        data[13 + offset] = this.field_5_ibstFltAutoNum;
        data[14 + offset] = this.field_6_grfhic;
        data[15 + offset] = this.field_7_reserved3;
    }

    public static int getSize() {
        return 16;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[LFO]\n");
        builder.append("    .lsid                 = ");
        builder.append(" (").append(this.getLsid()).append(" )\n");
        builder.append("    .reserved1            = ");
        builder.append(" (").append(this.getReserved1()).append(" )\n");
        builder.append("    .reserved2            = ");
        builder.append(" (").append(this.getReserved2()).append(" )\n");
        builder.append("    .clfolvl              = ");
        builder.append(" (").append(this.getClfolvl()).append(" )\n");
        builder.append("    .ibstFltAutoNum       = ");
        builder.append(" (").append(this.getIbstFltAutoNum()).append(" )\n");
        builder.append("    .grfhic               = ");
        builder.append(" (").append(this.getGrfhic()).append(" )\n");
        builder.append("         .fHtmlChecked             = ").append(this.isFHtmlChecked()).append('\n');
        builder.append("         .fHtmlUnsupported         = ").append(this.isFHtmlUnsupported()).append('\n');
        builder.append("         .fHtmlListTextNotSharpDot     = ").append(this.isFHtmlListTextNotSharpDot()).append('\n');
        builder.append("         .fHtmlNotPeriod           = ").append(this.isFHtmlNotPeriod()).append('\n');
        builder.append("         .fHtmlFirstLineMismatch     = ").append(this.isFHtmlFirstLineMismatch()).append('\n');
        builder.append("         .fHtmlTabLeftIndentMismatch     = ").append(this.isFHtmlTabLeftIndentMismatch()).append('\n');
        builder.append("         .fHtmlHangingIndentBeneathNumber     = ").append(this.isFHtmlHangingIndentBeneathNumber()).append('\n');
        builder.append("         .fHtmlBuiltInBullet       = ").append(this.isFHtmlBuiltInBullet()).append('\n');
        builder.append("    .reserved3            = ");
        builder.append(" (").append(this.getReserved3()).append(" )\n");
        builder.append("[/LFO]\n");
        return builder.toString();
    }

    public int getLsid() {
        return this.field_1_lsid;
    }

    public void setLsid(int field_1_lsid) {
        this.field_1_lsid = field_1_lsid;
    }

    public int getReserved1() {
        return this.field_2_reserved1;
    }

    public void setReserved1(int field_2_reserved1) {
        this.field_2_reserved1 = field_2_reserved1;
    }

    public int getReserved2() {
        return this.field_3_reserved2;
    }

    public void setReserved2(int field_3_reserved2) {
        this.field_3_reserved2 = field_3_reserved2;
    }

    public byte getClfolvl() {
        return this.field_4_clfolvl;
    }

    public void setClfolvl(byte field_4_clfolvl) {
        this.field_4_clfolvl = field_4_clfolvl;
    }

    public byte getIbstFltAutoNum() {
        return this.field_5_ibstFltAutoNum;
    }

    public void setIbstFltAutoNum(byte field_5_ibstFltAutoNum) {
        this.field_5_ibstFltAutoNum = field_5_ibstFltAutoNum;
    }

    public byte getGrfhic() {
        return this.field_6_grfhic;
    }

    public void setGrfhic(byte field_6_grfhic) {
        this.field_6_grfhic = field_6_grfhic;
    }

    public byte getReserved3() {
        return this.field_7_reserved3;
    }

    public void setReserved3(byte field_7_reserved3) {
        this.field_7_reserved3 = field_7_reserved3;
    }

    public void setFHtmlChecked(boolean value) {
        this.field_6_grfhic = (byte)fHtmlChecked.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlChecked() {
        return fHtmlChecked.isSet(this.field_6_grfhic);
    }

    public void setFHtmlUnsupported(boolean value) {
        this.field_6_grfhic = (byte)fHtmlUnsupported.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlUnsupported() {
        return fHtmlUnsupported.isSet(this.field_6_grfhic);
    }

    public void setFHtmlListTextNotSharpDot(boolean value) {
        this.field_6_grfhic = (byte)fHtmlListTextNotSharpDot.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlListTextNotSharpDot() {
        return fHtmlListTextNotSharpDot.isSet(this.field_6_grfhic);
    }

    public void setFHtmlNotPeriod(boolean value) {
        this.field_6_grfhic = (byte)fHtmlNotPeriod.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlNotPeriod() {
        return fHtmlNotPeriod.isSet(this.field_6_grfhic);
    }

    public void setFHtmlFirstLineMismatch(boolean value) {
        this.field_6_grfhic = (byte)fHtmlFirstLineMismatch.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlFirstLineMismatch() {
        return fHtmlFirstLineMismatch.isSet(this.field_6_grfhic);
    }

    public void setFHtmlTabLeftIndentMismatch(boolean value) {
        this.field_6_grfhic = (byte)fHtmlTabLeftIndentMismatch.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlTabLeftIndentMismatch() {
        return fHtmlTabLeftIndentMismatch.isSet(this.field_6_grfhic);
    }

    public void setFHtmlHangingIndentBeneathNumber(boolean value) {
        this.field_6_grfhic = (byte)fHtmlHangingIndentBeneathNumber.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlHangingIndentBeneathNumber() {
        return fHtmlHangingIndentBeneathNumber.isSet(this.field_6_grfhic);
    }

    public void setFHtmlBuiltInBullet(boolean value) {
        this.field_6_grfhic = (byte)fHtmlBuiltInBullet.setBoolean(this.field_6_grfhic, value);
    }

    public boolean isFHtmlBuiltInBullet() {
        return fHtmlBuiltInBullet.isSet(this.field_6_grfhic);
    }
}

