/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFunctionResolver;
import org.joox.Context;
import org.joox.DefaultContext;
import org.joox.JOOX;
import org.joox.Match;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Util {
    private static volatile boolean xalanExtensionLoaded = false;
    private static NamespaceContext xalanNamespaceContext;
    private static XPathFunctionResolver xalanFunctionResolver;
    private static final Pattern PATTERN_DD_MM_YYYY;
    private static final Pattern PATTERN_YYYY_MM_DD;

    Util() {
    }

    static final DocumentFragment createContent(Document doc, String text) {
        if (text != null && text.contains("<")) {
            DocumentBuilder builder = JOOX.builder();
            try {
                if (text.startsWith("<?xml")) {
                    Document parsed = builder.parse(new InputSource(new StringReader(text)));
                    DocumentFragment fragment = parsed.createDocumentFragment();
                    fragment.appendChild(parsed.getDocumentElement());
                    return (DocumentFragment)doc.importNode(fragment, true);
                }
                String wrapped = "<dummy>" + text + "</dummy>";
                Document parsed = builder.parse(new InputSource(new StringReader(wrapped)));
                DocumentFragment fragment = parsed.createDocumentFragment();
                NodeList children = parsed.getDocumentElement().getChildNodes();
                while (children.getLength() > 0) {
                    fragment.appendChild(children.item(0));
                }
                return (DocumentFragment)doc.importNode(fragment, true);
            }
            catch (IOException ignore) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return null;
    }

    static final String attr(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return null;
    }

    static final List<Element> importOrDetach(Document document, Element ... elements) {
        ArrayList<Element> detached = new ArrayList<Element>();
        for (Element e : elements) {
            if (document != e.getOwnerDocument()) {
                detached.add((Element)document.importNode(e, true));
                continue;
            }
            detached.add((Element)e.getParentNode().removeChild(e));
        }
        return detached;
    }

    static final Element[] elements(Match ... content) {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        for (Match x : content) {
            result.addAll(x.get());
        }
        return result.toArray(new Element[result.size()]);
    }

    static final String toString(Element element) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(element);
            StreamResult target = new StreamResult(out);
            transformer.transform(source, target);
            return out.toString();
        }
        catch (Exception e) {
            return "[ ERROR IN toString() : " + e.getMessage() + " ]";
        }
    }

    static final boolean hasElementNodes(NodeList list) {
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    static final String xpath(Element element) {
        StringBuilder sb = new StringBuilder();
        Node iterator = element;
        while (iterator.getNodeType() == 1) {
            sb.insert(0, "]");
            sb.insert(0, Util.siblingIndex(iterator) + 1);
            sb.insert(0, "[");
            sb.insert(0, iterator.getTagName());
            sb.insert(0, "/");
            iterator = iterator.getParentNode();
        }
        return sb.toString();
    }

    static final String path(Element element) {
        StringBuilder sb = new StringBuilder();
        Node iterator = element;
        while (iterator.getNodeType() == 1) {
            sb.insert(0, iterator.getTagName());
            sb.insert(0, "/");
            iterator = iterator.getParentNode();
        }
        return sb.toString();
    }

    private static final int siblingIndex(Element element) {
        if (element.getParentNode() == element.getOwnerDocument()) {
            return 0;
        }
        return JOOX.$(element).parent().children(element.getTagName()).get().indexOf(element);
    }

    static final Context context(Element match, int matchIndex, int matchSize) {
        return new DefaultContext(match, matchIndex, matchSize);
    }

    static final Context context(Element match, int matchIndex, int matchSize, Element element, int elementIndex, int elementSize) {
        return new DefaultContext(match, matchIndex, matchSize, element, elementIndex, elementSize);
    }

    static final String nonNull(String string) {
        return string == null ? "" : string;
    }

    static final List<String> split(String value) {
        ArrayList<String> result = new ArrayList<String>();
        SplitState state = SplitState.NEW;
        StringBuilder sb = new StringBuilder();
        block21: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (state) {
                case NEW: 
                case NEW_WITH_AT_LEAST_ONE_WORD: {
                    switch (c) {
                        case ',': 
                        case ';': {
                            state = SplitState.NEW_WITH_AT_LEAST_ONE_WORD;
                            result.add("");
                            continue block21;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block21;
                        }
                        case '\"': {
                            state = SplitState.DELIMITED;
                            continue block21;
                        }
                    }
                    state = SplitState.NON_DELIMITED;
                    sb.append(c);
                    continue block21;
                }
                case DELIMITED: {
                    switch (c) {
                        case '\"': {
                            if (i + 1 < value.length() && value.charAt(i + 1) == '\"') {
                                sb.append(c);
                                ++i;
                                continue block21;
                            }
                            if (i + 1 < value.length() && !Arrays.asList(Character.valueOf(','), Character.valueOf(';'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r')).contains(Character.valueOf(value.charAt(i + 1)))) {
                                sb.append(c);
                                continue block21;
                            }
                            if (i + 1 < value.length() && Arrays.asList(Character.valueOf(','), Character.valueOf(';')).contains(Character.valueOf(value.charAt(i + 1)))) {
                                result.add(sb.toString());
                                sb = new StringBuilder();
                                state = SplitState.NEW_WITH_AT_LEAST_ONE_WORD;
                                ++i;
                                continue block21;
                            }
                            result.add(sb.toString());
                            sb = new StringBuilder();
                            state = SplitState.NEW;
                            continue block21;
                        }
                    }
                    sb.append(c);
                    continue block21;
                }
                case NON_DELIMITED: {
                    switch (c) {
                        case ',': 
                        case ';': {
                            result.add(sb.toString());
                            sb = new StringBuilder();
                            state = SplitState.NEW_WITH_AT_LEAST_ONE_WORD;
                            continue block21;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            result.add(sb.toString());
                            sb = new StringBuilder();
                            state = SplitState.NEW;
                            continue block21;
                        }
                    }
                    sb.append(c);
                    continue block21;
                }
            }
        }
        switch (state) {
            case NEW: {
                break;
            }
            case NEW_WITH_AT_LEAST_ONE_WORD: 
            case DELIMITED: 
            case NON_DELIMITED: {
                result.add(sb.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static final void xalanExtensionAware(XPath xpath) {
        if (!xalanExtensionLoaded) {
            Class<Util> clazz = Util.class;
            // MONITORENTER : org.joox.Util.class
            if (!xalanExtensionLoaded) {
                xalanExtensionLoaded = true;
                try {
                    xalanNamespaceContext = (NamespaceContext)Class.forName("org.apache.xalan.extensions.ExtensionNamespaceContext").newInstance();
                    xalanFunctionResolver = (XPathFunctionResolver)Class.forName("org.apache.xalan.extensions.XPathFunctionResolverImpl").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // MONITOREXIT : clazz
        }
        if (xalanNamespaceContext == null) return;
        if (xalanFunctionResolver == null) return;
        xpath.setNamespaceContext(xalanNamespaceContext);
        xpath.setXPathFunctionResolver(xalanFunctionResolver);
    }

    static Date parseDate(String formatted) {
        if (formatted == null || formatted.trim().equals("")) {
            return null;
        }
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar calendar = factory.newXMLGregorianCalendar(formatted);
            return calendar.toGregorianCalendar().getTime();
        }
        catch (Exception e) {
            Matcher matcher = PATTERN_DD_MM_YYYY.matcher(formatted);
            if (matcher.find()) {
                String yyyy = matcher.group(3);
                String mm = matcher.group(2);
                String dd = matcher.group(1);
                String hh = Util.defaultIfEmpty(matcher.group(4), "0");
                String min = Util.defaultIfEmpty(matcher.group(5), "0");
                String ss = Util.defaultIfEmpty(matcher.group(6), "0");
                String ms = Util.defaultIfEmpty(matcher.group(7), "0");
                return Util.getDate(Integer.parseInt(yyyy), Integer.parseInt(mm), Integer.parseInt(dd), Integer.parseInt(hh), Integer.parseInt(min), Integer.parseInt(ss), Integer.parseInt(ms));
            }
            Matcher matcher2 = PATTERN_YYYY_MM_DD.matcher(formatted);
            if (matcher2.find()) {
                String yyyy = matcher2.group(1);
                String mm = Util.defaultIfEmpty(matcher2.group(2), "1");
                String dd = Util.defaultIfEmpty(matcher2.group(3), "1");
                String hh = Util.defaultIfEmpty(matcher2.group(4), "0");
                String min = Util.defaultIfEmpty(matcher2.group(5), "0");
                String ss = Util.defaultIfEmpty(matcher2.group(6), "0");
                String ms = Util.defaultIfEmpty(matcher2.group(7), "0");
                return Util.getDate(Integer.parseInt(yyyy), Integer.parseInt(mm), Integer.parseInt(dd), Integer.parseInt(hh), Integer.parseInt(min), Integer.parseInt(ss), Integer.parseInt(ms));
            }
            try {
                return new Date(Long.parseLong(formatted));
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        }
    }

    private static Date getDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(year, month - 1, day, hour, minute, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    static String defaultIfEmpty(String string, String defaultString) {
        if (string == null || string.equals("")) {
            return defaultString;
        }
        return string;
    }

    static {
        PATTERN_DD_MM_YYYY = Pattern.compile("^(\\d{2})[-\\./](\\d{2})[-\\./](\\d{4})(?:\\s(\\d{2})(?:[-\\./:](\\d{2})(?:[-\\./:](\\d{2})(?:\\.(\\d+))?)?)?)?$");
        PATTERN_YYYY_MM_DD = Pattern.compile("^(\\d{4})(?:[-\\./](\\d{2})(?:[-\\./](\\d{2})(?:(?:[\\sT]|'T')(\\d{2})(?:[-\\./:](\\d{2})(?:[-\\./:](\\d{2})(?:\\.(\\d+))?)?)?)?)?)?$");
    }

    static enum SplitState {
        NEW,
        NEW_WITH_AT_LEAST_ONE_WORD,
        DELIMITED,
        NON_DELIMITED;

    }
}

