/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class SMT {
    private int m;
    private char[] x;
    private int[] bmBc;
    private int[] qsBc;

    private static void preBmBc(char[] x, int[] bmBc) {
        int i;
        int m = x.length;
        for (i = 0; i < bmBc.length; ++i) {
            bmBc[i] = m;
        }
        for (i = 0; i < m - 1; ++i) {
            bmBc[x[i]] = m - i - 1;
        }
    }

    private static void preQsBc(char[] x, int[] qsBc) {
        int i;
        int m = x.length;
        for (i = 0; i < qsBc.length; ++i) {
            qsBc[i] = m + 1;
        }
        for (i = 0; i < m; ++i) {
            qsBc[x[i]] = m - i;
        }
    }

    private static int arrayCmp(char[] a, int aIdx, char[] b, int bIdx, int length) {
        int i = 0;
        for (i = 0; i < length && aIdx + i < a.length && bIdx + i < b.length; ++i) {
            if (a[aIdx + i] == b[bIdx + i]) continue;
            if (a[aIdx + i] > b[bIdx + i]) {
                return 1;
            }
            return 2;
        }
        if (i < length) {
            if (a.length - aIdx == b.length - bIdx) {
                return 0;
            }
            if (a.length - aIdx > b.length - bIdx) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static List<Integer> findAll(String pattern, String source) {
        int j;
        char[] x = pattern.toCharArray();
        char[] y = source.toCharArray();
        int m = x.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] bmBc = new int[65536];
        int[] qsBc = new int[65536];
        SMT.preBmBc(x, bmBc);
        SMT.preQsBc(x, qsBc);
        for (j = 0; j < n - m; j += Math.max(bmBc[y[j + m - 1]], qsBc[y[j + m]])) {
            if (SMT.arrayCmp(x, 0, y, j, m) != 0) continue;
            result.add(j);
        }
        if (j == n - m && SMT.arrayCmp(x, 0, y, j, m) == 0) {
            result.add(j);
        }
        return result;
    }

    public static SMT compile(String pattern) {
        char[] x = pattern.toCharArray();
        int m = x.length;
        int[] bmBc = new int[65536];
        int[] qsBc = new int[65536];
        SMT.preBmBc(x, bmBc);
        SMT.preQsBc(x, qsBc);
        SMT smt = new SMT();
        smt.bmBc = bmBc;
        smt.m = m;
        smt.qsBc = qsBc;
        smt.x = x;
        return smt;
    }

    public List<Integer> findAll(String source) {
        int j;
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (j = 0; j < n - this.m; j += Math.max(this.bmBc[y[j + this.m - 1]], this.qsBc[y[j + this.m]])) {
            if (SMT.arrayCmp(this.x, 0, y, j, this.m) != 0) continue;
            result.add(j);
        }
        if (j == n - this.m && SMT.arrayCmp(this.x, 0, y, j, this.m) == 0) {
            result.add(j);
        }
        return result;
    }
}

