/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTFParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("rtf"));
    private static final Pattern F_PATTERN = Pattern.compile("\\\\a?f([0-9]+)");
    private static final Pattern FCHARSET_PATTERN = Pattern.compile("\\\\fcharset[0-9]+");
    private static final Pattern ANSICPG_PATTERN = Pattern.compile("\\\\ansicpg[0-9]+");
    private static final Pattern DEFAULT_FONT_PATTERN = Pattern.compile("\\\\deff(0-9)+");
    private static final Pattern FONT_FAMILY_PATTERN = Pattern.compile("\\\\f(nil|roman|swiss|modern|script|decor|tech|bidi)");
    private static Map<Integer, String> FONTSET_MAP = new HashMap<Integer, String>();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        File tempFile = null;
        FileInputStream in = null;
        try {
            tempFile = this.createUnicodeRtfTempFile(stream);
            in = new FileInputStream(tempFile);
            CustomStyledDocument sd = new CustomStyledDocument();
            new RTFEditorKit().read(in, (Document)sd, 0);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.element("p", sd.getText(0, sd.getLength()));
            xhtml.endDocument();
        }
        catch (BadLocationException e) {
            try {
                throw new TikaException("Error parsing an RTF document", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private String escapeByUnicode(String data, String enc) {
        StringBuilder dataBuf = new StringBuilder(data.length() + 16);
        StringBuilder keywordBuf = new StringBuilder(4);
        StringBuilder origDataBuf = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < data.length(); ++i) {
            char c1 = data.charAt(i);
            keywordBuf.append(c1);
            if (c1 == '\\' && data.length() > i + 1) {
                char c2 = data.charAt(++i);
                keywordBuf.append(c2);
                if (c2 == '\'') {
                    char c3 = data.charAt(++i);
                    keywordBuf.append(c3);
                    if (c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F') {
                        char c4 = data.charAt(++i);
                        keywordBuf.append(c4);
                        if (c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F') {
                            int value = Integer.parseInt(String.valueOf(new char[]{c3, c4}), 16);
                            baos.write(value);
                            origDataBuf.append(keywordBuf.toString());
                            keywordBuf.delete(0, 4);
                            continue;
                        }
                    }
                }
            }
            if (baos.size() != 0) {
                try {
                    this.appendUnicodeStr(dataBuf, new String(baos.toByteArray(), enc));
                }
                catch (UnsupportedEncodingException e) {
                    dataBuf.append(origDataBuf.toString());
                }
                origDataBuf.delete(0, origDataBuf.length());
                baos.reset();
            }
            dataBuf.append(keywordBuf.toString());
            keywordBuf.delete(0, 4);
        }
        if (baos.size() != 0) {
            try {
                this.appendUnicodeStr(dataBuf, new String(baos.toByteArray(), enc));
            }
            catch (UnsupportedEncodingException e) {
                dataBuf.append(origDataBuf.toString());
            }
        }
        return dataBuf.toString();
    }

    private void appendUnicodeStr(StringBuilder dataBuf, String value) {
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            if (ch >= '\u0014' && ch < 'P') {
                dataBuf.append(ch);
                continue;
            }
            dataBuf.append("{\\u");
            dataBuf.append((int)ch);
            dataBuf.append('}');
        }
    }

    private File createUnicodeRtfTempFile(InputStream in) throws IOException {
        boolean isDelete = false;
        File tempFile = null;
        BufferedOutputStream out = null;
        try {
            int ch;
            tempFile = File.createTempFile("temp", ".rtf");
            out = new BufferedOutputStream(new FileOutputStream(tempFile));
            String defaultCharset = "windows-1251";
            String defaultFont = "0";
            HashMap<String, String> fontTableMap = new HashMap<String, String>();
            StringBuilder dataBuf = new StringBuilder(255);
            LinkedList<String> charsetQueue = new LinkedList<String>();
            int depth = 0;
            String prevFt = null;
            int prevCh = -1;
            while ((ch = in.read()) != -1) {
                if ((ch == 123 || ch == 125) && prevCh != 92 || ch == 32 && !FONT_FAMILY_PATTERN.matcher(dataBuf.toString()).find()) {
                    if (charsetQueue.size() > depth + 1) {
                        charsetQueue.removeLast();
                    }
                    String data = dataBuf.toString();
                    if ((data = data.replace("\\cell", "\\u0020\\cell")).indexOf("\\colortbl") != -1) {
                        prevFt = null;
                    }
                    if (depth == 1) {
                        Matcher matcher;
                        String cset = this.loadAnsiCpg(data);
                        if (cset != null) {
                            defaultCharset = cset;
                        }
                        if ((matcher = DEFAULT_FONT_PATTERN.matcher(data)).find()) {
                            defaultFont = matcher.group(1);
                        }
                    }
                    String ft = this.loadFontTable(data);
                    String charset = this.loadCharset(data);
                    if (ft != null && charset != null) {
                        fontTableMap.put(ft, charset);
                    }
                    if (ft == null && prevCh == 32) {
                        ft = prevFt;
                    } else if (ft != null) {
                        prevFt = ft;
                    }
                    if (ft == null) {
                        ft = defaultFont;
                    }
                    if (charset == null && ft != null) {
                        charset = (String)fontTableMap.get(ft);
                    }
                    if (charset == null && charsetQueue.size() > 0) {
                        charset = (String)charsetQueue.getLast();
                    }
                    if (charset == null) {
                        charset = defaultCharset;
                    }
                    if (charsetQueue.size() < depth + 1) {
                        charsetQueue.add(charset);
                    }
                    String escapedStr = "windows-1251".equals(charset) ? data : this.escapeByUnicode(data, charset);
                    out.write(escapedStr.getBytes("UTF-8"));
                    out.write(ch);
                    dataBuf.delete(0, dataBuf.length());
                    prevCh = ch;
                    if (ch == 123) {
                        ++depth;
                        continue;
                    }
                    if (ch != 125) continue;
                    --depth;
                    continue;
                }
                dataBuf.append((char)ch);
            }
            out.flush();
        }
        catch (IOException e) {
            try {
                isDelete = true;
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                if (isDelete && tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        if (isDelete && tempFile != null) {
            tempFile.delete();
        }
        return tempFile;
    }

    private String loadFontTable(String line) {
        Matcher m = F_PATTERN.matcher(line);
        String font = null;
        while (m.find()) {
            font = m.group(1);
        }
        return font;
    }

    private String loadAnsiCpg(String line) {
        Matcher m = ANSICPG_PATTERN.matcher(line);
        String charset = null;
        if (m.find()) {
            try {
                int encVal = Integer.parseInt(m.group().substring(8));
                charset = FONTSET_MAP.get(encVal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return charset;
    }

    private String loadCharset(String line) {
        Matcher m = FCHARSET_PATTERN.matcher(line);
        String charset = null;
        if (m.find()) {
            int encVal;
            try {
                encVal = Integer.parseInt(m.group().substring(9));
            }
            catch (NumberFormatException e) {
                encVal = 0;
            }
            charset = FONTSET_MAP.get(encVal);
        }
        return charset;
    }

    static {
        FONTSET_MAP.put(0, "windows-1251");
        FONTSET_MAP.put(77, "MacRoman");
        FONTSET_MAP.put(78, "Shift_JIS");
        FONTSET_MAP.put(79, "ms949");
        FONTSET_MAP.put(80, "GB2312");
        FONTSET_MAP.put(81, "Big5");
        FONTSET_MAP.put(82, "johab");
        FONTSET_MAP.put(83, "MacHebrew");
        FONTSET_MAP.put(84, "MacArabic");
        FONTSET_MAP.put(85, "MacGreek");
        FONTSET_MAP.put(86, "MacTurkish");
        FONTSET_MAP.put(87, "MacThai");
        FONTSET_MAP.put(88, "cp1250");
        FONTSET_MAP.put(89, "cp1251");
        FONTSET_MAP.put(128, "MS932");
        FONTSET_MAP.put(129, "ms949");
        FONTSET_MAP.put(130, "ms1361");
        FONTSET_MAP.put(134, "ms936");
        FONTSET_MAP.put(136, "ms950");
        FONTSET_MAP.put(161, "cp1253");
        FONTSET_MAP.put(162, "cp1254");
        FONTSET_MAP.put(163, "cp1258");
        FONTSET_MAP.put(177, "cp1255");
        FONTSET_MAP.put(178, "cp1256");
        FONTSET_MAP.put(186, "cp1257");
        FONTSET_MAP.put(204, "cp1251");
        FONTSET_MAP.put(222, "ms874");
        FONTSET_MAP.put(238, "cp1250");
        FONTSET_MAP.put(254, "cp437");
        FONTSET_MAP.put(255, "cp850");
    }

    private static class NoReclaimStyleContext
    extends StyleContext {
        private NoReclaimStyleContext() {
        }

        public void reclaim(AttributeSet a) {
        }
    }

    private static class CustomStyledDocument
    extends DefaultStyledDocument {
        private boolean isPrevUnicode = false;

        public CustomStyledDocument() {
            super(new NoReclaimStyleContext());
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean isUnicode;
            boolean bl = isUnicode = str.length() == 1 && str.charAt(0) > '\u007f';
            if (offs > 0 && offs == this.getLength() && !this.isPrevUnicode && !isUnicode) {
                super.insertString(offs, " ", a);
                super.insertString(this.getLength(), str, a);
            } else {
                super.insertString(offs, str, a);
            }
            this.isPrevUnicode = isUnicode;
        }
    }
}

