/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IWorkPackageParser
implements Parser {
    private static final Set<MediaType> supportedTypes = Collections.singleton(MediaType.application("vnd.apple.iwork"));
    private static final Set<String> relevantFileNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("index.apxl", "index.xml", "presentation.apxl")));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream(stream);
        ArchiveEntry entry = ((ArchiveInputStream)zip).getNextEntry();
        Parser parser = context.get(Parser.class, EmptyParser.INSTANCE);
        while (entry != null) {
            if (!relevantFileNames.contains(entry.getName())) {
                entry = ((ArchiveInputStream)zip).getNextEntry();
                continue;
            }
            parser.parse(new CloseShieldInputStream(zip), handler, metadata, context);
            entry = ((ArchiveInputStream)zip).getNextEntry();
        }
        ((InputStream)zip).close();
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

