package javax.xml.stream.internal;

import javax.xml.stream.FactoryFinderAccessor;
import javax.xml.stream.internal.classloading_utils.OsgiEnvironmentClassLoader;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator implements BundleActivator {
	
	//@Override
	public void start(BundleContext bundleContext) throws Exception {
		if (isUseOsgiEnvironmentClassLoader(bundleContext)) {
			FactoryFinderAccessor.updateStaxImplClassLoader(newOsgiEnironmentClassLoader(bundleContext));
		}
	}
	
	//@Override
	public void stop(BundleContext bundleContext) throws Exception {
		FactoryFinderAccessor.updateStaxImplClassLoader(null);
	}
	
	
	protected boolean isUseOsgiEnvironmentClassLoader(BundleContext bundleContext) {
		try {
			String useOsgiClassLoaderValue = bundleContext.getProperty(USE_OSGI_CLASS_LOADER_PROPERTY);
			if (useOsgiClassLoaderValue != null && Boolean.parseBoolean(useOsgiClassLoaderValue) == false) {
				return false;
			} else {
				return true;
			}
		} catch (Throwable ex) {
			return true;
		}
	}
	
	protected OsgiEnvironmentClassLoader newOsgiEnironmentClassLoader(BundleContext bundleContext) {
		return new OsgiEnvironmentClassLoader(
				bundleContext,
				Thread.currentThread().getContextClassLoader(),
				bundleContext.getBundle());
	}
	
	
	public static final String USE_OSGI_CLASS_LOADER_PROPERTY =
		"javax.xml.stream:use_osgi_class_loader";
	
}
