/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author  Alexander Quast <alexander.quast@open-xchange.com>
 */

ox.gui.initToolBarNewWindowMailDetail = function () {

    var $p = ox.gui.initToolBarNewWindow();
    
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * Mail
         */
        mail: {
            "reply": {
                title: _("Reply"),
                icons: ["reply.png"],
                big: true
            },
            "reply-all": {
                title: _("Reply all"),
                icons: ["reply_all.png"],
                big: true
            },
            "forward": {
                title: _("Forward"),
                icons: ["forward.png"],
                big: true
            },
            "delete": {
                title: _("Delete"),
                icons: ["delete.png"],
                big: true
            },
            "edit": {
                title: _("Edit draft"),
                icons: ["draft.png"],
                big: true
            },
            "save": {
                title: _("Save"),
                icons: ["send_as_link.png"]
            },
            "view-source": {
                title: _("Show source"),
                icons: ["mail_source.png"]
            },
            "print": {
                title: _("Print"),
                icons: ["print.png"]
            },
            "mark-as": {
                title: _("Mark as"),
                icons: ["mark_as.png"]
            },
            "mark-as-read": {
                title: _("Read")
            },
            "mark-as-unread": {
                title: _("Unread")
            },
            "mark-as-answered": {
                title: _("Answered"),
                requires: ["write"]
            },
            "mark-as-unanswered": {
                title: _("Unanswered"),
                requires: ["write"]
            },
            "mark-as-deleted": {
                title: _("Deleted"),
                requires: ["delete"]
            },
            "mark-as-undeleted": {
                title: _("Undeleted"),
                requires: ["delete"]
            },
            "copy": {
                title: _("Copy"),
                icons: ["mail_copy.png"],
                requires: ["some"]
            },
            /*
             * Cancel/Close
             */
            "cancel": {
                title: _("Close"),
                big: true,
                icons: ["cancel.png"]
           }
        }
    });
    
    
    // SPAM buttons
    (function () {
        
        // get some config parameter
        var spamButton = ox.api.config.get("mail.spambutton", false);
        var spamFolder = ox.api.config.get("mail.folder.spam");
        
        var folder = url.folder;
        var accountId = ox.api.folder.derive("accountId", folder);
        
        if (spamButton === true && accountId === 0 && folder !== spamFolder) {
            meta.mail.spam = {
                title: _("Spam"),
                icons: ["spam.png"]
            };
        }
        else if (spamButton === true && folder === spamFolder) {
            meta.mail.ham = {
                title: _("No Spam"),
                icons: ["ham.png"]
            };
        }
        
    }());
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.mail = new ox.gui.TabMenu(
        $p.getOptions({
            id: "toolbar-mail",
            showSectionNames: false
        })
    );
    
    // edit
    tab = tabs.mailEdit = new ox.gui.PanelMenu("toolbar-mail-edit",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+E for '&Edit'
        _("&Edit")).addTo(toolbar);
    // section
    section = new ox.gui.PanelMenuSection(_("Edit")).addTo(tab);
    // add items
    add(section, meta.mail, "mail_detail-edit",
        ["reply", "reply-all", "forward", "delete",
         "print", "mark-as", "save"
        ]
    );
    
    // add spam/ham
    if (meta.mail.spam) {
        add(section, meta.mail, "mail_detail-edit", ["spam"]);
    } else if (meta.mail.ham) {
        add(section, meta.mail, "mail_detail-edit", ["ham"]);
    }
    
    // add other items
    add(section, meta.mail, "mail_detail-edit", ["view-source"]);
    
    // section "cancel"
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.mail, "mail_detail", ["cancel"]);
    
    // add to "mark as"
    add(items["mail_detail-edit-mark-as"], meta.mail, "mail_detail-edit",
        ["mark-as-read", "mark-as-unread",
         "mark-as-answered", "mark-as-unanswered",
         "mark-as-deleted", "mark-as-undeleted"
        ]
    );
    
    // Tagging (Flags & Categories)
    tab = tabs.mailTagging = new ox.gui.PanelMenu("toolbar-mail-tag",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+F for '&Flags'
        _("&Flags")).addTo(toolbar);
    // section
    section = new ox.gui.PanelMenuSection(_("Flags"), "mailFlagsSection").addTo(tab);
    // add items
    add(section, meta.flags, "mail_detail-flag",
       ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"]
    );
    
    /*
     * Add handler
     */
    
    // event hash
    var events = {
        // edit mail
        "mail_detail-compose-compose": "OX_NEW_MAIL",
        "mail_detail-edit-reply": "OX_Mail_Reply",
        "mail_detail-edit-reply-all": "OX_Mail_ReplyAll",
        "mail_detail-edit-forward": "OX_Mail_Forward",
        "mail_detail-edit-delete": "OX_Mail_Delete",
        "mail_detail-edit-edit": "OX_Mail_Edit_Draft",
        "mail_detail-edit-copy": "OX_Mail_Copy",
        "mail_detail-edit-move": "OX_Mail_Move",
        "mail_detail-edit-save": "OX_Mail_SaveMail",
        "mail_detail-edit-view-source": "OX_Mail_Show_Source",
        "mail_detail-edit-print": "OX_Print",
        "mail_detail-cancel" : "OX_Cancel_Object",
        "mail_detail-edit-spam": "OX_Mail_Spam",
        "mail_detail-edit-ham": "OX_Mail_Ham"
    };
    
    // mapping of mail flags
    var mailFlags = {
        "read": "seen", 
        "unread": "unseen",
        "answered": "answer", 
        "unanswered": "answered",
        "deleted": "delete", 
        "undeleted": "undelete"
    };
    
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {
        // regex matches
        var m;
        
        // defined by event?
        if (events[id] !== undefined) {
            // trigger
            triggerEvent(events[id]);
            return true;
        }
        
        // is mail mark?
        m = id.match(/^mail_detail-edit-mark-as-(\w+)$/);
        if (m && m.length) {
            // trigger event
            triggerEvent("OX_Mail_Flag", mailFlags[m[1]]);
            return true;
        }
        
        // is flag/mark?
        m = id.match(/^\w+-flag-(\d+)$/);
        if (m && m.length) {
            // trigger event
            triggerEvent("OX_Add_Flag", m[1]);
            return true;
        }
    });
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    ox.desktop.validate();
    ox.api.window.core.triggerEvent("OX_Window_Toolbar_Ready", {
        handle : window.url.guid,
        type : "maildetail"
    });
};