/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author  Alexander Quast <alexander.quast@open-xchange.com>
 */

ox.gui.initToolBarNewWindowMail = function () {

    var $p = ox.gui.initToolBarNewWindow();
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New Mail Window
         */
        "window_mail": {
            "send": {
                title: _("Send"),
                icons: ["mail_send.png"],
                big: true,
                selection: "default"
            },
            "save-draft": {
                title: _("Save draft"),
                icons: ["mail_write.png"],
                big: true,
                requires: function() {
                    // check if we can save
                    return true; 
                }
            },
            "view": {
                title: _("View"),
                big: true,
                icons: ["options.png"]
            },
            "from": {
                title: _("From"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.from")
            },
            "cc": {
                title: _("CC"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.cc")
            },
            "bcc": {
                title: _("BCC"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.bcc")
            },
            "options": {
                title: _("Options"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.options")
            },
            "attachment-add": {
                title: _("Add attachment"),
                icons: ["attachment_add.png"],
                big: true
            },
            "attachment-add-file": {
                title: _("Attach local file"),
                icons: ["attachment_add.png"]
            },
            "attachment-add-infoitem": {
                title: _("Attach InfoItem"),
                icons: ["attachment_add.png"],
                requires: function(ability) {
                    return ox.api.config.get("modules.infostore.module");
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/mail/new/add_infostore_attachment", window);
                    }
                }
            },
            "attachment-remove": {
                title: _("Remove attachment"),
                icons: ["attachment_remove.png"],
                selection: "attachments",
                requires: ["some"],
                big: true
            },
            "cancel": {
                 title: _("Cancel"),
                 big: true,
                 icons: ["cancel.png"]
            }
        }
    });
    
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.detailMail = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-mail-menu",
            showSectionNames: false
        })
    );
    
    // main tab
    tab = tabs.newMailWindow = new ox.gui.PanelMenu(
        "window-mail-main", _("&E-Mail")).addTo(toolbar);
    
    section = new ox.gui.PanelMenuSection(_("Mail")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["send", "save-draft"]);
    
    section = new ox.gui.PanelMenuSection(_("Mail")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["attachment-add", "attachment-remove"]);
    
    // add sub items
    add(items["mail_new-attachment-add"], ox.widgets.toolBar.meta.window_mail, "mail_new", 
        ["attachment-add-file", "attachment-add-infoitem"]
    );
    
    section = new ox.gui.PanelMenuSection(_("View")).addTo(tab);
    // add items
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["view"]
    );
    
    add(items["mail_new-view"], ox.widgets.toolBar.meta.window_mail, "mail_new", ["from", "cc", "bcc", "options"]);
    
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["cancel"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    // bind to subselected
    register("SubSelected", function(array) {
        ox.ToolBarController.processSelection("attachments", false, array ,true);
    });
    
    // event mapping
    
    var events = {
            "mail_new-send" : "OX_SAVE_OBJECT",
            "mail_new-save-draft" : "OX_Save_Template_Object",
            "mail_new-attachment-add-file": "OX_Object_Add_Attachment",
            "mail_new-attachment-add-infoitem": "OX_Object_Add_Attachment_Infostore",
            "mail_new-attachment-remove" : "OX_Object_Attachment_Delete",
            "mail_new-cancel" : "OX_Cancel_Object"
    };
  
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {
        
        // regex matches
        var m;
        
        // defined by event?
        if (events[id] !== undefined) {
            // trigger
            triggerEvent(events[id]);
            return true;
        }      
        
        // individual handlers
        switch (id) {
        case "mail_new-from":
            triggerEvent("OX_New_Mail_Show_Additional_Header", "from", 
                    !ox.api.config.get("gui.mail.newmail_options.from"));
            return true;
        case "mail_new-cc":
            triggerEvent("OX_New_Mail_Show_Additional_Header", "cc", 
                    !ox.api.config.get("gui.mail.newmail_options.cc"));
            return true;
        case "mail_new-bcc":
            triggerEvent("OX_New_Mail_Show_Additional_Header", "bcc", 
                    !ox.api.config.get("gui.mail.newmail_options.bcc"));
            return true;
        case "mail_new-options":
            triggerEvent("OX_New_Mail_Show_Additional_Header", "options", 
                    !ox.api.config.get("gui.mail.newmail_options.options"));
            return true;
        }
    });
    
    ox.desktop.validate();
    ox.api.window.core.triggerEvent("OX_Window_Toolbar_Ready", {
            handle : window.url.guid,
            type : "mail"
    });
    // initial redraw to update icon state
    ox.ToolBarController.processSelection("default", false, [], true);
    ox.ToolBarController.processSelection("attachments", false, [], true);
};