/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

/*jslint bitwise: false, nomen: false, onevar: false, plusplus: false, regexp: false, white: true, browser: true, devel: true, evil: true, forin: true, undef: true, eqeqeq: true, immed: true */

/*global ox, jQuery, $, triggerEvent, menuswitchMailView */

ox.gui.initToolBarPermissions = function ($p) {
    
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * Folder/object permissions
         */
        permissions: {
            // save button
            save: {
                title: _("Save"),
                icons: ["save.png"],
                big: true,
                action: function() {
                    triggerEvent("OX_SAVE_OBJECT");
                }
            },
            // add permission
            add: {
                title: _("Add user"),
                icons: ["userrights.png"],
                action: function () {
                    // call magic global function with really self-explaining name TODO: fix!
                    ox.api.folder.get({
                        folder: configparentfolder != -1 ? configparentfolder : configfolder,
                        success: function (oFolder) {
                            triggerEvent('OX_Configuration_Add_User', oFolder);
                        }
                    });
                }
            },
            remove: {
                title: _("Remove user"),
                icons: ["userrights_remove.png"],
                action: function () {
                    // trigger event
                    triggerEvent("OX_Configuration_Remove_User");
                }
            },
            // folder admin
            adminYes: {
                title: _("Administrator"),
                icons: ["mod_configuration.png"],
                action: function() {
                    changeRights("ADMIN", 1);
                },
                behavior: "radio",
                group: "permissions-admin"
            },
            adminNo: {
                title: _("User"),
                icons: ["user.png"],
                action: function() {
                    changeRights("ADMIN", 0);
                },
                behavior: "radio",
                group: "permissions-admin"
            },
            // folder permissions
            folderNone: {
                title: _("None"),
                icons: ["delete_folder.png"],
                action: function() {
                    changeRights("FOLDER", 0);
                },
                behavior: "radio",
                group: "permissions-folder"
            },
            folderVisible: {
                title: _("Visible folder"),
                icons: ["folder_closed.png"],
                action: function() {
                    changeRights("FOLDER", 1);
                },
                behavior: "radio",
                group: "permissions-folder"
            },
            folderCreateObjects: {
                title: _("Create objects"),
                icons: ["folder_closed.png"],
                action: function() {
                    changeRights("FOLDER", 2);
                },
                behavior: "radio",
                group: "permissions-folder"
            },
            folderCreateFolders: {
                title: _("Create subfolders"),
                icons: ["folder_opened.png"],
                action: function() {
                    changeRights("FOLDER", 4);
                },
                behavior: "radio",
                group: "permissions-folder"
            },
            folderMax: {
                title: _("Maximum"),
                icons: ["folder_opened.png"],
                action: function() {
                    changeRights("FOLDER", 64);
                },
                behavior: "radio",
                group: "permissions-folder"
            },
            // object permissions
            // read
            readNone: {
                title: _("None"),
                icons: ["userrights_read.png"],
                action: function() {
                    changeRights("READ", 0);
                },
                behavior: "radio",
                group: "permissions-read"
            },
            readOwn: {
                title: _("Read own"),
                icons: ["userrights_read.png"],
                action: function() {
                    changeRights("READ", 1);
                },
                behavior: "radio",
                group: "permissions-read"
            },
            readAll: {
                title: _("Read all"),
                icons: ["userrights_read.png"],
                action: function() {
                    changeRights("READ", 2);
                },
                behavior: "radio",
                group: "permissions-read"
            },
            readMax: {
                title: _("Maximum"),
                icons: ["userrights_read.png"],
                action: function() {
                    changeRights("READ", 64);
                },
                behavior: "radio",
                group: "permissions-read"
            },
            // write/modify
            modifyNone: {
                title: _("None"),
                icons: ["userrights_write.png"],
                action: function() {
                    changeRights("WRITE", 0);
                },
                behavior: "radio",
                group: "permissions-write"
            },
            modifyOwn: {
                title: _("Modify own"),
                icons: ["userrights_write.png"],
                action: function() {
                    changeRights("WRITE", 1);
                },
                behavior: "radio",
                group: "permissions-write"
            },
            modifyAll: {
                title: _("Modify all"),
                icons: ["userrights_write.png"],
                action: function() {
                    changeRights("WRITE", 2);
                },
                behavior: "radio",
                group: "permissions-write"
            },
            modifyMax: {
                title: _("Maximum"),
                icons: ["userrights_write.png"],
                action: function() {
                    changeRights("WRITE", 64);
                },
                behavior: "radio",
                group: "permissions-write"
            },
            // delete
            deleteNone: {
                title: _("None"),
                icons: ["userrights_delete.png"],
                action: function() {
                    changeRights("DELETE", 0);
                },
                behavior: "radio",
                group: "permissions-delete"
            },
            deleteOwn: {
                title: _("Delete own"),
                icons: ["userrights_delete.png"],
                action: function() {
                    changeRights("DELETE", 1);
                },
                behavior: "radio",
                group: "permissions-delete"
            },
            deleteAll: {
                title: _("Delete all"),
                icons: ["userrights_delete.png"],
                action: function() {
                    changeRights("DELETE", 2);
                },
                behavior: "radio",
                group: "permissions-delete"
            },
            deleteMax: {
                title: _("Maximum"),
                icons: ["userrights_delete.png"],
                action: function() {
                    changeRights("DELETE", 64);
                },
                behavior: "radio",
                group: "permissions-delete"
            }
        }
    });
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = new ox.gui.TabMenu(
        $p.getOptions({
            id: "toolbar-permissions",
            showSectionNames: false
        })
    );
    
    // shortcuts
    configToolbars.folderPermissions = ox.widgets.toolBar.views.permissions = toolbar;
    
    /*
     * Tab: Save/Add/Remove
     */
    tab = tabs.permissionsForFolders = new ox.gui.PanelMenu("toolbar-permissions-save",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+N for '&New'
        _("&Save")).addTo(toolbar);
    
    // section "save"
    section = new ox.gui.PanelMenuSection(_("Save")).addTo(tab);
    // add items
    add(section, meta.permissions, "permissions-save",
        ["save", "add", "remove"]
    );
    
    /*
     * Tab: Folder permissions
     */
    tab = tabs.permissionsForFolders = new ox.gui.PanelMenu("toolbar-permissions-folder",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+N for '&New'
        _("&Folder permissions")).addTo(toolbar);
    
    // section "folder admin"
    section = new ox.gui.PanelMenuSection(_("Folder admin")).addTo(tab);
    // add items
    add(section, meta.permissions, "permissions-folder",
        ["adminYes", "adminNo"]
    );
    
    // section "folder permissions"
    section = new ox.gui.PanelMenuSection(_("Folder permissions")).addTo(tab);
    // add items
    add(section, meta.permissions, "permissions-folder",
        ["folderNone", "folderVisible", "folderCreateObjects", "folderCreateFolders", "folderMax"]
    );
    
    /*
     * Tab: Object permissions
     */
    tab = tabs.permissionsForObjects = new ox.gui.PanelMenu("toolbar-permissions-object",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+N for '&New'
        _("&Object permissions")).addTo(toolbar);
    
    // section "object permissions: READ" 
    section = new ox.gui.PanelMenuSection(_("Read")).addTo(tab);
    // add items
    add(section, meta.permissions, "permissions-object",
        ["readNone", "readOwn", "readAll", "readMax"]
    );
    
    // section "object permissions: WRITE"
    section = new ox.gui.PanelMenuSection(_("Modify")).addTo(tab);
    // add items
    add(section, meta.permissions, "permissions-object",
        ["modifyNone", "modifyOwn", "modifyAll", "modifyMax"]
    );
    
    // section "object permissions: DELETE"
    section = new ox.gui.PanelMenuSection(_("Delete")).addTo(tab);
    // add items
    add(section, meta.permissions, "permissions-object",
        ["deleteNone", "deleteOwn", "deleteAll", "deleteMax"]
    );
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
};