/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

ox.gui.initToolBarMessaging = function ($p) {

    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        messaging: {
            "new": {
                title: _("New"),
                icons: ["img/mail/btn_sendmail.gif"],
                big: true
            }
        }
    });
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.messaging = new ox.gui.TabMenu(
        $p.getOptions({
            id: "toolbar-messaging",
            showSectionNames: false
        })
    );
    
    // new
    tab = tabs.messaging = new ox.gui.PanelMenu(
        "toolbar-messaging-new", _("&Messaging")).addTo(toolbar);
    section = new ox.gui.PanelMenuSection(_("Message")).addTo(tab);
    add(section, meta.messaging, "messaging", ["new"]);
    
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {
        if (id == "messaging-new") {
            triggerEvent("NewMessage");
            return true;
        }
        return false;
    });
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
};