/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

ox.gui.initToolBarContacts = function ($p) {

    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        contacts: {
            compose: {
                title: _("New contact"),
                icons: ["mod_contacts.png"],
                big: true
            },
            composeDistributionList: {
                title: _("New distribution list"),
                icons: ["distributionlist.png"],
                big: true
            },
            edit: {
                title: _("Edit"),
                icons: ["edit.png"],
                big: true,
                requires: ["one", "modify"]
            },
            "delete": {
                title: _("Delete"),
                icons: ["delete.png"],
                big: true,
                requires: ["some", "delete"]
            },
            print: {
                title: _("Print"),
                icons: ["print.png"],
                big: true,
                requires: ["some"]
            },
            duplicate: {
                title: _("Use as template"),
                icons: ["duplicate_contacts.png"],
                requires: ["one"]
            },
            move: {
                title: _("Move"),
                icons: ["contact_move.png"],
                requires: ["some", "delete"]
            },
            copy: {
                title: _("Copy"),
                icons: ["contact_copy.png"],
                requires: ["some"]
            },
            "vcard": {
                title: _("Send as vCard"),
                icons: ["forward.png"],
                requires: ["some"]
            },
            
            /*Attachments*/
            "attachment-open": {
                title: _("Open attachment"),
                icons: ["attachment_open.png"],
                selection: "attachments",
                requires: function(ability) {
                    return ability.one;
                }
            },
            "attachment-save": {
                title: _("Save as"),
                icons: ["send_as_attachment.png"],
                selection: "attachments",
                requires: function(ability) {
                    return ability.one;
                }
            },
            "attachment-save-infostore": {
                title: _("Save in InfoStore"),
                icons: ["save.png"],
                selection: "attachments",
                requires: function(ability) {
                    return ability.one;
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/contacts/save_to_infostore", window);
                    }
                }
            }
        },
        contactsView: {
            cards: {
                title: _("Cards"),
                icons: ["card_view.png"],
                behavior: "radio",
                group: "contacts-view",
                big: true,
                checked: function () {
                    return currentpath[1] === "cards";
                }
            },
            phonelist: {
                title: _("Phone list"),
                icons: ["list_view.png"],
                behavior: "radio",
                group: "contacts-view",
                big: true,
                checked: function () {
                    return currentpath[1] === "phonelist";
                }
            },
            detail: {
                title: _("Detail"),
                icons: ["detail_view.png"],
                requires: ["one"],
                behavior: "radio",
                group: "contacts-view",
                big: true,
                checked: function () {
                    return currentpath[1] === "detail";
                }
            }
        }
    });
    
    
    // toggles attachment section
    var toggleAttachmentSection = function () {
        if (currentpath[0] === "contacts") {
            // get parent tab
            var tab = ox.widgets.toolBar.tabs.contactsEdit;
            var section = tab.children[2];
            var visible = section.isVisible();
            // in team view?
            if (currentpath[2] === "attachment") {
                if (!visible) {
                    section.setVisible(true);
                    tab.validate();
                }
            } else if (visible) {
                section.setVisible(false);
                tab.validate();
            }
        }
    };
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var sections = ox.widgets.toolBar.sections;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.contacts = new ox.gui.TabMenu(
        $p.getOptions({
            id: "toolbar-contacts",
            showSectionNames: false
        })
    );
    
    // new
    tab = tabs.contactsCreate = new ox.gui.PanelMenu("toolbar-contacts-create",
        _("&New")).addTo(toolbar);
    section = sections.contactsCreate = new ox.gui.PanelMenuSection(_("New"), "contactsCreateSection").addTo(tab);
    add(section, meta.create, "contacts-create",
        ["mail", "calendar", "contact", "distributionlist", "task", "file"]
    );
    // edit
    tab = tabs.contactsEdit = new ox.gui.PanelMenu("toolbar-contacts-edit",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+E for '&Edit'
        _("&Edit")).addTo(toolbar);
    // section
    section = sections.contactsCompose = new ox.gui.PanelMenuSection(_("Compose"), "contactsComposeSection").addTo(tab);
    // add items
    add(section, meta.contacts, "contacts-edit",
        ["compose", "composeDistributionList"]
    );
    // section
    section = sections.contactsEdit = new ox.gui.PanelMenuSection(_("Edit"), "contactsEditSection").addTo(tab);
    // add items
    add(section, meta.contacts, "contacts-edit",
        ["edit", "delete", "print", "duplicate", "vcard", "move", "copy"]
    );
    
    // section attachments, will only be shown in attachment tab
    section = sections.contactsAttachment = new ox.gui.PanelMenuSection(_("Attachments"), "contactsAttachmentSection").addTo(tab);
    // add items
    add(section, meta.contacts, "contacts-edit",
        ["attachment-open", "attachment-save", "attachment-save-infostore"]
    );
    
    // view
    tab = tabs.contactsView = new ox.gui.PanelMenu("toolbar-contacts-view",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+V for '&View'
        _("&View")).addTo(toolbar);
    section = sections.contactsView = new ox.gui.PanelMenuSection(_("View"), "contactsViewSection").addTo(tab);
    add(section, meta.contactsView, "contacts-view",
        ["cards", "phonelist", "detail"]);
    
    // Tagging (Flags & Categories)
    tab = tabs.contactsTagging = new ox.gui.PanelMenu("toolbar-contacts-tag",
        //#. '&' before a letter indicates a shortcut, i.e. Alt+F for '&Flags'
        _("&Flags")).addTo(toolbar);
    section = sections.contactsFlags = new ox.gui.PanelMenuSection(_("Flags"), "contactsFlagsSections").addTo(tab);
    add(section, meta.flags, "contacts-flag",
       ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"]);
    
    // Add section search when embbedded mode is on
    if (corewindow.embedded) {
        ox.widgets.searchField.contacts = new ox.gui.SearchField("ox-topbar-search-contacts").
        addListener("widget:search", function(e) {
            triggerEvent("OX_New_Search", ox.api.ui.getActiveModule(), e.data.value);
        });
        
        tab = tabs.contactsSearch = new ox.gui.PanelMenu("toolbar-contacts-search",
                _("&Search")).addTo(toolbar);
        // section
        section = sections.contactsSearch = new ox.gui.PanelMenuSection(_("Search"), "contactsSearchSection").addTo(tab);
        // add items
        section.add(ox.widgets.searchField.contacts);
    }
    
    /*
     * Add handler
     */
    
    // event hash
    var events = {
        "contacts-edit-compose": "OX_Before_Create_Contact",
        "contacts-edit-composeDistributionList": "OX_Before_Create_Distributionlist",
        "contacts-edit-edit": "OX_Contact_Edit",
        "contacts-edit-print": "OX_Print",
        "contacts-edit-duplicate": "OX_Contact_Duplicate",
        "contacts-edit-move": "OX_Contact_Move",
        "contacts-edit-copy": "OX_Contact_Copy",
        "contacts-edit-delete": "OX_Contact_Delete",
        "contacts-edit-vcard": "OX_Contact_SendVCard",
        "contacts-edit-attachment-save" : "OX_Attachment_Save",
        "contacts-edit-attachment-save-infostore" : "OX_Attachment_SaveInfoStore"
    };
    
    var views = {
        "contacts-view-cards": "cards",
        "contacts-view-phonelist": "phonelist",
        "contacts-view-detail": "detail"
    };
    
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {
        if (id in events) {
            triggerEvent(events[id]);
            return true;
        }
        if (id in views) {
            menuswitchContactView(views[id]);
            return true;
        }
        switch(id){
            case "contacts-edit-attachment-open":
                triggerEvent(menunestedmessage ? "OX_Attachment_Open_Nested" : "OX_Attachment_Open");
                return true;
        }
        return false;
    });
    
    // attachments section visibile only in attachments tab
    ox.api.event.register("OX_View_Changed", function(){
        toggleAttachmentSection();
        
        if (currentpath[0] === "contacts" && currentpath[2] !== "attachments") {
            ox.ToolBarController.processSelection("attachments", false, [], true);
        }
    });
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);

    // initial processing of selection
    ox.ToolBarController.processSelection("attachments", false, [], true);
    
    // "edit" tab is default
    ox.ToolBarController.setDefaultTab(toolbar, 1);
};