/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2009 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * @ignore
 */

// DEVELOPMENT IN PROGRESS // SUBJECT TO PERMANENT CHANGE!


ox.gui.ViewControl = ox.gui.StatefulContainer.extend({
/** @lends ox.gui.ViewControl.prototype */
    
    getClass: function () { return "ox.gui.ViewControl"; },
    
    /** 
     * A view controller. Allows only one child to be active and displayed.
     * @constructs
     * @extends ox.gui.StatefulContainer
     * @param {String} id An optional unique id for the widget.
     */
    construct: function (id) {
        
        // call super class constructor (inherit from Container)
        this._super(this.autoId(id, "viewControl"));
        
        this.setLayout(new ox.gui.ZeroLayout());
        this.addCSSClass("oxStretch");
        
        // local constructor
        this.activeView = null;
        this.lastView = null;
        this.views = {};
    },
    
    add: function (view) {
        // must be an instance of ox.gui.Widget
        if (view instanceof ox.gui.Widget) {
            // invisible
            view.statusVisible = true; // required to force paintInvisible (see next row)
            view.setVisible(false);
            // call super class method
            ox.gui.StatefulContainer.prototype.add.call(this, view);
            // first added view?
            if (!this.activeView) {
                this.activeView = view;
                this.activeView.setVisible(true);
                this.triggerWidgetEvent("viewchanged", this.activeView);
            }
            // add to index
            this.views[view.id] = view;
        } else {
            console.error("ox.gui.ViewControl.add(<view>)", "<view> must be an instance of ox.gui.Widget!");
        }
        // support chaining
        return this;
    },
    
    getState: function () {
        this.currentState = this.activeView.id;
        // call super class method
        return ox.gui.StatefulContainer.prototype.getState.call(this);
    },
    
    setState: function (state) {
        // call super class method
        ox.gui.StatefulContainer.prototype.setState.call(this, state);
        this.showView(this.currentState);
    },
    
    /**
     * Get the position of the active view.
     * @returns {Int} The position.
     */
    getPosition: function () {
        return this.activeView.position;
    },

    /**
     * Set the new active view by its position
     * @param {Int} position The position of the child.
     */
    setPosition: function (position) {
        // switch view
        if (position <= this.children.length - 1) {
            this.showView(this.children[position].id);
        }
    },
    
    /**
     * @private
     */
    hideActiveView: function () {
        if (this.activeView !== null) {
            // hide
            this.activeView.setVisible(false);
            this.currentState = "";
            this.validate();
        }
    },
    
    /**
     * Shows the given view.
     * @param {string} view The view to be shown (id).
     */
    showView: function (id) {
        // switch view
        if (this.views[id] !== undefined) {
            // hide active view
            this.hideActiveView();
            // remember last view
            this.lastView = this.activeView;
            // show view
            this.activeView = this.views[id];
            this.activeView.setVisible(true);
            this.currentState = id;
            // trigger event
            this.triggerWidgetEvent("viewchanged", this.activeView);
            // validate
            this.validate();
        }
    },
    
    showLastView: function () {
        if (this.lastView) {
            this.showView(this.lastView.id);
        }
    }
});

// -----------------------------------------------------------------------------

ox.gui.View = ox.gui.Container.extend({
/** @lends ox.gui.View.prototype */
    
    getClass: function() { return "ox.gui.View"; },
    
    /** 
     * A view container. A valid child for ox.gui.ViewController.
     * @constructs
     * @extends ox.gui.Container
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
        this._super(id);
        this.addCSSClass("oxStretch");
        this.statusVisible = false;
    }    
});
