/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

var messagingServices = {
    callbacks: [],
    value: undefined,
    get: function(callback) {
        if (this.callbacks) {
            this.callbacks.push(callback);
        } else {
            callback(this.value);
        }
    },
    set: function(value) {
        if (!this.callbacks) throw "Multiple set calls";
        this.value = value;
        for (var i = 0; i < this.callbacks.length; i++) {
            this.callbacks[i](value);
        }
        this.callbacks = null;
    }
};

register("OX_Configuration_Loaded_Complete", function() {
    
    if (!configGetKey("modules.messaging.module")) return;
    
    // VSplit
    
    ox.JSON.get(
        AjaxRoot + "/messaging/service?action=all&session=" + session,
        function(reply) {
            var services = {};
            for (var i = 0; i < reply.data.length; i++) {
                services[reply.data[i].id] = reply.data[i];
            }
            messagingServices.set(services);
        });
    
    var node = new ox.Configuration.LeafNode("configuration/messaging",
        newnode("span",0,0,[
            newnode("span", 0, 0, [addTranslated(_("Messaging"))]), 
            newnode("span", { background:"orange", marginLeft:"5px",
                              padding:"2px", MozBorderRadius:"2px",
                              WebkitBorderRadius:"2px", color:"white"
                            }, 0, [addTranslated(_("Preview"))]) 
        ]));
    var split = new ox.Configuration.VSplit(node,
        _("Social Messaging accounts"), 0.3);
    split.init = function() {
        
        split.list = new LiveGrid([{
            text: _("Account"),
            index: "displayName",
            clear: LiveGrid.makeClear(""),
            set: LiveGrid.defaultSet
        }], new Selection());
        split.list.emptylivegridtext = _("No Messaging accounts configured.");

        var name = new ox.UI.Input(_("Name"));
        split.addWidget(name, "displayName");
        var form = new ox.Configuration.DynamicForm(_("Type"),
            "messagingService", "configuration");
        form.immutableType = true;
        split.addWidget(form, ox.Configuration.Group.NoField);
        messagingServices.get(function(services) {
            form.setMetadata(services);
        });
        
        // Menu
        
        //menuarrows[node.id] = {};
        var menu = MenuNodes.createSmallButtonContext("messaging.account",
            _("Accounts"));
        MenuNodes.createSmallButton(menu, "messaging.account.add", _("Add"),
            getFullImgSrc("img/menu/add_category.gif"),
            getFullImgSrc("img/menu/add_category_d.gif"),
            function() {
                split.addNew({ displayName: _("New messaging service")
                                });
                setFocus(name.formnode);
            });
        MenuNodes.createSmallButton(menu, "messaging.account.remove",
            _("Remove"),
            getFullImgSrc("img/menu/remove_category.gif"),
            getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
        addMenuNode(menu.node, MenuNodes.FIXED, 31);
        changeDisplay(node.id, "messaging.account");
        
        register("OX_SELECTED_ITEMS_CHANGED", function() {
            var deleteenabled = split.list.selection.count > 0;
            menuglobalzaehler = 0;
            //menuarrows[node.id]["messaging.account"] = [];
            menu_display_contents(node.id, "messaging.account", true,
                "messaging.account.add");
            menu_display_contents(node.id, "messaging.account", deleteenabled,
                "messaging.account.remove");
        });

        function confirmDelete() {
            if (!split.list.selection.count) return;
            //#. Social Messaging accounts
            newConfirm(ngettext("Delete Account", "Delete Accounts",
                                split.list.selection.count),
                //#. Social Messaging accounts
                ngettext(
                    "Are you sure you want to delete the selected account?",
                    "Are you sure you want to delete the selected accounts?",
                    split.list.selection.count),
                AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
        }
        function handleDelete() {
            var accounts = split.list.selection.getSelected();
            var data = new Array(accounts.length);
            for (var i = 0; i < accounts.length; i++) {
                data[i] = {
                    module: "messaging/account", action: "delete",
                    messagingService: accounts[i].messagingService,
                    id: accounts[i].id
                };
            }
            
            ox.JSON.put(AjaxRoot + "/multiple?session=" + session, data,
                function(reply) {
                    split.list.storage.removeIDs(accounts);
                    ox.api.folder.refresh();
                });
        }
      
    };
    
    function jsonToData(json) {
        return {
            id: { id: json.id, messagingService: json.messagingService },
            messagingService: json.messagingService,
            displayName: json.displayName,
            configuration: json.configuration
        };
    }
    
    function dataToJson(data) {
        var json = {
            messagingService: data.messagingService,
            displayName: data.displayName,
            configuration: data.configuration
        };
        if (data.id) {
            json.id = data.id.id;
            json.messagingService = data.id.messagingService;
        }
        return json;
    }
    
    function load(id, cont) {
        ox.JSON.get(AjaxRoot +
            "/messaging/account?action=get&messagingService=" +
            id.messagingService + "&id=" + id.id + "&session=" + session,
            function(reply) { cont(jsonToData(reply.data)); });
    }
    
    split.enableList = function() {
        ox.JSON.get(
            AjaxRoot + "/messaging/account?action=all&session=" + session,
            function(reply) {
                var storage = new Storage(0, [], 0, 0, 0,
                    function(id) { return id.messagingService + "/" + id.id; },
                    function(data) { return data.id; });
                var data = new Array(reply.data.length);
                for (var i = 0; i < data.length; i++) {
                    data[i] = jsonToData(reply.data[i]);
                }
                storage.append(data);
                split.list.enable(storage);
            });
    };
        
    split.load = function(cont) {
        messagingServices.get(function(services) {
            load(split.list.selection.getSelected()[0], cont);
        });
    };
    
    split.save = function(data, cont) {
        if ("id" in data) {
            ox.JSON.put(AjaxRoot +
                "/messaging/account/?action=update&session=" + session,
                dataToJson(data),
                function(reply) {
                    load(data.id, function(loadedData) {
                        split.list.storage.localUpdate([loadedData.id],
                            function(old) { return loadedData; });
                        //oMain-FolderTree.cache.update(null, true, null);
                        ox.api.folder.refresh();
                        cont(loadedData);
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/messaging/account/?action=new&session=" +
                session, dataToJson(data),
                function(reply) {
                    load({
                        id: reply.data,
                        messagingService: data.messagingService
                    }, function(loadedData) {
                        split.list.storage.append([loadedData]);
//                        oMain-FolderTree.cache.update(null, true, null);
                        ox.api.folder.refresh();
                        cont(loadedData);
                    });
                });
        }
    };
    
});