/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
 
/**
 * define day
 */
function cDay(nDateParam,nCurrMonthParam,bWeekendParam)
{
	this.nDate = nDateParam;
	this.nCurrMonth = nCurrMonthParam; 		 //flags: 0 last month, 1 current month, next month
	this.bWeekend = bWeekendParam;			 //true, false
}

/**
 * define week
 */
function cWeek()
{
	this.nKW;	
	this.aDays= new Array();	
	this.addDay = function (nDay,oDay)
	{
		this.aDays[nDay] = oDay;
	}
	this.setKW = function (nKWParam)	
	{
		this.nKW = nKWParam;
	}
}

/*
 * defines calender:
 */
function cCalendar(nMonthParam,nYearParam)
{
	this.nMonth = nMonthParam;
	this.nYear = nYearParam;
	this.aWeeks= new Array();
	/*
	 * compute Calendar
	 */
	this.addWeek = function (nNumWeek,oWeekParam)
	{
		this.aWeeks[nNumWeek] = oWeekParam;			
	}	
	 
	this.init = function ()
	{
		var oCalendarTool = new calendarTool(this.nMonth, this.nYear);
		oCalendarTool.init();		
		var nNumWeeks = oCalendarTool.getNumWeeks();
		var	startByDate = oCalendarTool.endDate - oCalendarTool.firstDay+1;			
		var nDayCounter = 0; var nDayNextMonth = 1;var nDayCurrMonth = 1;
		for(nWeek=0;nWeek < nNumWeeks;nWeek++)
		{			
			var oWeek = new cWeek();
			var oThDate = new Date();
			oThDate.setFullYear(oCalendarTool.nYear);
			oThDate.setDate(1);	
			oThDate.setMonth(oCalendarTool.nMonth);				
			
			for(indexDay=0;indexDay<7;indexDay++)
			{				
				if(indexDay > 4)
				 	bWeekend = true;
				else				 	
				 	bWeekend = false;				 	
				if(nDayCounter<oCalendarTool.firstDay)
				{
					var oDay = new cDay(startByDate+nDayCounter,0,bWeekend);
					if(indexDay==3) //th
					{
						oThDate.setDate(startByDate+nDayCounter);
						oThDate.setMonth(oThDate.getMonth()-1);						
					}
				}				
				else if(nDayCounter>=(oCalendarTool.nDays+oCalendarTool.firstDay))
				{
					var oDay = new cDay(nDayNextMonth,2,bWeekend);
					if(indexDay==3) //Th
					{
						oThDate.setDate(nDayNextMonth);
						oThDate.setMonth(oThDate.getMonth()+1);		
					}
					nDayNextMonth++;
				}				
				else
				{
					var oDay = new cDay(nDayCurrMonth,1,bWeekend);
					if(indexDay==3)
					{					
						oThDate.setDate(nDayCurrMonth);
						oThDate.setMonth(oThDate.getMonth());
					}
					nDayCurrMonth++;
				}	
				oWeek.addDay(indexDay,oDay);
				oWeek.setKW(oCalendarTool.getKW(oThDate.getFullYear(),oThDate.getMonth(),oThDate.getDate()));				
				nDayCounter++;
			}
			this.addWeek(nWeek,oWeek);
		}		
	}
	
	this.init();	

}

/*
 * tools for calendar computing
 */
function calendarTool(nMonthParam,nYearParam) {
	this.firstDay;
	this.startWeek;
	this.endDate;
	this.nDays;	
	
	this.nMonth = nMonthParam;	
	this.nYear = nYearParam;	
	this.curr_date;	
	this.init = function () {
		var currDate = new Date();
		currDate.setFullYear(this.nYear);
		currDate.setDate(1);
		currDate.setMonth(this.nMonth);
		currDate.setUTCDate(currDate.getUTCDate()-1);

		this.endDate = currDate.getDate();	
		currDate.setUTCDate(currDate.getUTCDate()+1);	
		this.startWeek =  this.getKW(currDate.getFullYear(),currDate.getMonth(),1);
		this.firstDay = currDate.getDay();
		if(this.firstDay>0) this.firstDay -= 1;	
		else if(this.firstDay==0) this.firstDay=6;		
		//compute num days	
		currDate.setMonth(currDate.getMonth()+1);
		currDate.setUTCDate(currDate.getUTCDate()-1);
		this.nDays = currDate.getDate();		
		this.curr_date = currDate;
	}
	
	this.getNumWeeks = function() {	
		var fullWeeks = parseInt(this.nDays/7);
		var overflow = this.nDays - fullWeeks*7;
		if(this.firstDay > 0)
			fullWeeks++;
		if ((7 - this.firstDay) < overflow || (overflow>0 && this.firstDay==0)) {
			fullWeeks++;
		}
		return fullWeeks;
	}
	
	//private functions
	/*
	 * compute calendar week
	 */
	this.getKW = function (j,m,t) {
		var DoDat = this.donnerstag(new Date(j,m,t));
		var DoKW1 = this.donnerstag(new Date(this.getKWYear(j,m,t),0,4));
		var kw = Math.floor(1.5+(DoDat.getTime()-DoKW1.getTime())/86400000/7);
		return kw;
	}
	
	this.getKWYear = function(j,m,t) {
		return this.donnerstag(new Date(j,m,t)).getFullYear();
	}
	
	/*
	 * compute first thursday, getKW need it
	 */
	this.donnerstag = function (datum) {
	  var Do=new Date();
	  Do.setTime(datum.getTime() + (3-((datum.getDay()+6) % 7)) * 86400000);
	  return Do;
	}
	
	this.sonntag = function (datum) { 
	  var Do=new Date();
	  Do.setTime(datum.getTime() + (3-((datum.getDay()+6) % 7)) * 86400000);
	  Do.setUTCDate(Do.getUTCDate()-4);
	  return Do;
	}	
	
	this.init();
}
fileloaded();