/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

ox.gui.initToolBarConfig = function ($p) {

    
    temporary.configuration = {};
    
    var auto_id = 0;
    
    /**
     * Creates a new toolbar for a configuration page.
     * @param {String} title The title of the toolbar tab.
     * @param {Array} sections An array of section definitions. Each section
     * definition is an object with the folowing members:
     * - {String} title
     * - {Array} buttons An array with button definition. Each button definition
     *                   is an options object for ox.gui.MenuItem.
     * - {String} id An optional ID for the section. If not specified, a unique
     *               ID is generated automatically. In both cases, the ID is
     *               prefixed with "
     * @param {String} id An optional ID for the toolbar. If not specified,
     * a unique ID is generated automatically. In both cases, the ID is prefixed
     * with "config-" for the ox.gui.TabMenu and with "config-tab-" for
     * the ox.gui.PanelMenu.
     * @type ox.gui.PanelMenu
     * @return The created PanelMenu instance, which can be passed to
     * showToolbar() to display it.
     */
    temporary.configuration.newToolbar = function(title, sections, id) {
        var ID = (id || auto_id++);
        var toolbar = new ox.gui.TabMenu(
            $p.getOptions({
                id: "toolbar-" + ID,
                showSectionNames: false
            })
        );
        var tab = new ox.gui.PanelMenu("toolbar-" + ID + "-" + ID,
            title).addTo(toolbar);
        for (var i = 0; i < sections.length; i++) {
            var meta = sections[i];
            var section = sections[i] = new ox.gui.PanelMenuSection(meta.title);
            section.addTo(tab);
            for (var j = 0; j < meta.buttons.length; j++) {
                var button = meta.buttons[j];
                if (button.event) {
                    button.action = (function(event) {
                        return function() { triggerEvent(event); };
                    })(button.event);
                    delete button.event;
                }
                button.id = ID + "-" + (meta.id || i) + "-" + (button.id || j);
                var item = new ox.gui.MenuItem(button);
                ox.widgets.toolBar.menuItems[item.id] = item;
                section.add(item);
            }
        }
        toolbar.addTo(ox.widgets.toolBar.viewControl);
        // add resize handler
        toolbar.addListener("widget:togglehover", $p.resize);
        return toolbar;
    };
    
    /**
     * Switches to the specified toolbar.
     * This function is used by the configuration views instead of the default
     * handling because each configuration page has its own toolbar instance.
     * @param {ox.gui.PanelMenu} toolbar The toolbar to show.
     */
    temporary.configuration.showToolbar = function(toolbar) {
        ox.widgets.toolBar.viewControl.showView(toolbar.id);
        toolbar.setPosition(0);
        // TODO: fix temporary resize hack
        jQuery(window).trigger("resize");
    };
    
    /**
     * A section definition for the default configuration save button.
     * Normally used as the first array member of the second parameter to
     * newToolbar().
     */
    temporary.configuration.saveButton = {
        title: _("Save"),
        buttons: [{
            title: _("Save"),
            icons: ["img/menu/btn_save.gif"],
            big: true,
            event: "OX_SAVE_OBJECT"
        }]
    };
    
    temporary.configuration.defaultToolbar = temporary.configuration.newToolbar(
        _("Preferences"), [temporary.configuration.saveButton], "preferences");
};