/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
 
function portalMatrix (DOMdiv)
{
this.div = DOMdiv;    
this.nodes = new Array();
}
portalMatrix.prototype = {
    /*new portlet*/
    add:function (oOXPortlet,DOMElem, posX, posY){
        if(this.nodes[posY] == undefined)
        {
            for(var nRest=this.nodes.length;nRest <= posY;nRest++)
            {
                this.nodes[nRest] = new Array();
                var oNewDOMY = newnode("div",{width:"100%"});
                this.nodes[nRest][0] = {portlet:{},parent:oNewDOMY,div:newnode("div",{flt:"left"})};
                oNewDOMY.appendChild(this.nodes[nRest][0].div);
                this.div.appendChild(oNewDOMY);
            }
        }
        var aX = this.nodes[posY];
        //this.nodes[posY] must have content (x[0])
        var oDOMY = aX[0].div.parentNode;        
        for(var nRest=aX.length;nRest <= posX;nRest++)
        {                    
            aX[nRest] = {portlet:{},parent:oDOMY,div:newnode("div",{flt:"left"})};
            oDOMY.appendChild(aX[nRest].div);
        }
        if(aX[posX].portlet.id)
        {
            var newX = oDOMY.childNodes.length;
            aX[newX] = {portlet:{},parent:oDOMY,div:newnode("div",{flt:"left"})};
            oDOMY.appendChild(aX[newX].div);
            oDOMY.replaceChild(DOMElem,aX[newX].div);            
            aX[newX].div = DOMElem;
            aX[newX].portlet = oOXPortlet;
        }
        else
        {
            oDOMY.replaceChild(DOMElem,aX[posX].div);            
            aX[posX].div = DOMElem;
            aX[posX].portlet = oOXPortlet;        
        }
    },
    /*inserts new row and a portlet after node*/
    insert_rowBefore :function (oOXPortlet,DOMElem, nY){    
        var DOMNodeBefore = this.nodes[nY][0].parent;
        var oNewDOMY = newnode("div",{width:"100%"});
        this.nodes.splice(nY,0,[{portlet:oOXPortlet,parent:oNewDOMY,div:DOMElem}]);    
        oNewDOMY.appendChild(this.nodes[nY][0].div);        
        this.div.insertBefore(oNewDOMY,DOMNodeBefore);
    },
    /*inserts new portlet before node*/
    insertBefore :function (oOXPortlet,DOMElem, node){
        var oCoor = this.getXY(node);
        var posX = oCoor.x;        
        var posY = oCoor.y;        
        var parentN = this.nodes[posY][posX].parent;
        this.nodes[posY].splice((posX),0,{portlet:oOXPortlet,parent:parentN,div:DOMElem});    
        parentN.insertBefore(DOMElem,node);        
    },
    /*inserts new portlet before node*/
    replace :function (oOXPortlet,DOMElem, node){
        var oCoor = this.getXY(node);
        var posX = oCoor.x;        
        var posY = oCoor.y;
        var parentN = this.nodes[posY][posX].parent;
        this.nodes[posY][posX] = {portlet:oOXPortlet,parent:parentN,div:DOMElem};        
        parentN.replaceChild(this.nodes[posY][posX].div,node);        
    },
    /*inserts new portlet after node*/
    insert :function (oOXPortlet,DOMElem, node){        
        var oCoor = this.getXY(node);
        var posX = oCoor.x;        
        var posY = oCoor.y;
        var parentN = this.nodes[posY][posX].parent;
        var oDOMSibling = node.nextSibling;
        this.nodes[posY].splice((posX+1),0,{portlet:oOXPortlet,parent:parentN,div:DOMElem});
        if(oDOMSibling)
        {
            parentN.insertBefore(DOMElem,oDOMSibling);                        
        }
        else
        {
            parentN.appendChild(DOMElem);
        }
    },
    get :function (node){        
        var oCoor = this.getXY(node);
        var posX = oCoor.x;        
        var posY = oCoor.y;        
        return this.nodes[posY][posX];
    },
    /*removes from DOM and form internal array, returns old value (portlet, div)*/
    remove :function (node){        
        var oCoor = this.getXY(node);
        var posX = oCoor.x;        
        var posY = oCoor.y;        
        var oldVal = this.nodes[posY][posX];
        var parentN = this.nodes[posY][posX].parent;
        parentN.removeChild(node);

        this.nodes[posY][posX] = {portlet:{},parent:parentN,div:newnode("div",{flt:"left"})};
        return oldVal;
    },
    /*removes empty divs*/
    normalize : function (){
        var currParent;
        for(var nYindx=0;nYindx < this.nodes.length;nYindx++)        
        {
            currParent = this.nodes[nYindx][0].parent;
            var nLengthAr = this.nodes[nYindx].length;
            for(var nNode=0;nNode < nLengthAr;nNode++)
            {        
                var bdeleted = false;
                if(this.nodes[nYindx][nNode].portlet.container == undefined)
                {
                    this.nodes[nYindx].splice(nNode,1);    
                    bdeleted = true;
                    nNode--;
                    nLengthAr--;                
                }
                if(this.nodes[nYindx][nNode])
                {
                    this.nodes[nYindx][nNode].portlet.adjust = {x:nNode,y:nYindx,
                ww:(this.nodes[nYindx][nNode].portlet.adjust && this.nodes[nYindx][nNode].portlet.adjust.ww)?this.nodes[nYindx][nNode].portlet.adjust.ww:1,
                                hw:(this.nodes[nYindx][nNode].portlet.adjust && this.nodes[nYindx][nNode].portlet.adjust.hw)?this.nodes[nYindx][nNode].portlet.adjust.hw:1};
            
                }
            }

            if(this.nodes[nYindx].length == 0)
            {
                this.div.removeChild(currParent);
                this.nodes.splice(nYindx,1);
                nYindx = 0;
            }
        }
        
        for(var nYindx=0;nYindx < this.nodes.length;nYindx++)        
        {        
            //normalize width
            var nWWSum = 0;
            var nNumItems = this.nodes[nYindx].length;
            for(var nNode=0;nNode < nNumItems;nNode++)
            {
                if(this.nodes[nYindx][nNode].portlet.adjust == undefined)
                {
                    this.nodes[nYindx][nNode].portlet.adjust = {x:nNode,y:nYindx,ww:1,hw:1};
                }
                nWWSum += this.nodes[nYindx][nNode].portlet.adjust.ww;                        
                //disable/enable borders and resize divs here
                if(this.nodes[nYindx][nNode].portlet.resize_div != undefined)
                {
                    if((nNumItems-1) == nNode)
                    {
                        this.nodes[nYindx][nNode].portlet.resize_div.style.display = "none";
                    }
                    else
                    {                        
                        this.nodes[nYindx][nNode].portlet.resize_div.style.display = "block";
                        
                        //fixed bug with hidden resize buttons iin IE -> help ie to render the page
                        this.nodes[nYindx][nNode].portlet.resize_div.style.borderWidth = "2px";
                        this.nodes[nYindx][nNode].portlet.resize_div.style.borderWidth = "0px";                        
                    }
                }
            }                
            var nOffset = (1 - nWWSum/this.nodes[nYindx].length);        
            if(nOffset != 0)    
            {
                for(var nNode=0;nNode < this.nodes[nYindx].length;nNode++)
                {
                    this.nodes[nYindx][nNode].portlet.adjust.ww += nOffset;
                }
            }        
        }
    },
    /*
     * hides/shows owa iframes
     */
     hideshow_iframes:function (sMode)
     {
        for(var nYindx=0;nYindx < this.nodes.length;nYindx++)        
        {
            for(var nNode=0;nNode < this.nodes[nYindx].length;nNode++)
            {
                if(this.nodes[nYindx][nNode].portlet.uwa)
                {
                    if(sMode == "hide")
                    {
                        var div = newnode("div",0,{className:"background-color-content"});                
                        div.style.width = this.nodes[nYindx][nNode].portlet.container.offsetWidth + "px";
                        div.style.height = this.nodes[nYindx][nNode].portlet.container.offsetHeight + "px";
                        div.style.position = "absolute";
                        div.style.filter = "Alpha(opacity=0)";
                        div.style.mozOpacity = "0";
                        div.style.opacity = "0";        
                        div.style.display = "block";
                        addDOMEvent(div, "selectstart", function (e){stopEvent(e);return false;});
                        addDOMEvent(div, "drag", function (e){stopEvent(e);return false;});                                                    
                        this.nodes[nYindx][nNode].portlet.container.insertBefore(div,
                                        this.nodes[nYindx][nNode].portlet.container.firstChild);
                        this.nodes[nYindx][nNode].portlet.hideDiv = div;
                    }
                    else if(this.nodes[nYindx][nNode].portlet.hideDiv)
                    {
                        this.nodes[nYindx][nNode].portlet.container.removeChild(this.nodes[nYindx][nNode].portlet.hideDiv);
                    }
                }
            }
        }         
     },
    /*removes empty divs and resizes*/
    resize: function (sAreaWidth,sAreaHeight){
        this.normalize();
        if(sAreaWidth == 0 || sAreaHeight==0)
            return;
        var sHeight = (sAreaHeight/this.nodes.length - 4 -(2 * pxPerEm));
        var aLGSResize = new Array();

        for(var nYindx=0;nYindx < this.nodes.length;nYindx++)        
        {
            var sNormalWidth = ((sAreaWidth/this.nodes[nYindx].length));
            for(var nNode=0;nNode < this.nodes[nYindx].length;nNode++)
            {
                if(!this.nodes[nYindx][nNode].portlet.container)
                    continue;
                sWidth = this.nodes[nYindx][nNode].portlet.adjust.ww * sNormalWidth;
                if(this.nodes[nYindx][nNode].div.style.width == (sWidth-10) + 'px' && 
                            this.nodes[nYindx][nNode].div.style.height == sHeight + "px")
                {
                    continue;
                }                
                this.nodes[nYindx][nNode].div.style.width = (sWidth-15) + 'px';        
                this.nodes[nYindx][nNode].portlet.container.style.width = (sWidth-40) + 'px';                        
                this.nodes[nYindx][nNode].div.style.height = (sHeight+30) + "px";        
                this.nodes[nYindx][nNode].portlet.container.style.height = (sHeight-25)  + "px";            
                if(this.nodes[nYindx][nNode].portlet.uwa)
                {
                    this.nodes[nYindx][nNode].portlet.uwa.setConfiguration(
                                        {'height':sHeight-25});
                }
                if(this.nodes[nYindx][nNode].portlet.resize_div)
                {
                    this.nodes[nYindx][nNode].portlet.resize_div.style.height = (sHeight-10)  + "px";
                    this.nodes[nYindx][nNode].portlet.resize_div.style.left = 
                                                    this.nodes[nYindx][nNode].div.offsetLeft 
                                                            + this.nodes[nYindx][nNode].div.offsetWidth + "px";                        
                }
                for(var nLGSection in this.nodes[nYindx][nNode].portlet.ranges)
                {
                    var currLG = this.nodes[nYindx][nNode].portlet.ranges[nLGSection].lg;
                    if(currLG != undefined)
                        currLG.heightDiv.style.width = this.nodes[nYindx][nNode].portlet.container.style.width ;
                    //aLGSResize.push(currLG);
                }        
            }
            if(sHeight>0)
                this.nodes[nYindx][0].div.parentNode.style.height = (sHeight+30) + "px";        
        }
    },
    getXY : function (DOMElem){
         for(var nY=0;nY < this.nodes.length;nY++)
         {
             for(var nX=0;nX < this.nodes[nY].length;nX++)
             {
                 if(DOMElem == this.nodes[nY][nX].div)                 
                 {
                     return {x:nX,y:nY};            
                 }
             }
         }        
         return {x:0,y:0};
    },
    /*module can be replaced by id later*/
    getByModule : function (module){
         for(var nY=0;nY < this.nodes.length;nY++)
         {
             for(var nX=0;nX < this.nodes[nY].length;nX++)
             {
                 if(module == this.nodes[nY][nX].portlet.id)                 
                 {
                     return {x:nX,y:nY};            
                 }
             }
         }        
         return null;
    },
    setConfig : function (){
        var oConfigPortal = clone(configGetKey("gui.portal.internalcontents"));
        var oConfigExtPortal = clone(configGetKey("gui.portal.externalcontents"));
        for(var nYindx=0;nYindx < this.nodes.length;nYindx++)        
        {
            for(var nNode=0;nNode < this.nodes[nYindx].length;nNode++)
            {
                for(var nConfig=0;nConfig<oConfigPortal.length;nConfig++)
                {
                    var sId = (oConfigPortal[nConfig]["id"])?oConfigPortal[nConfig]["id"]:oConfigPortal[nConfig]["module"];
                    if(sId == this.nodes[nYindx][nNode].portlet.id)
                    {
                        oConfigPortal[nConfig].adj = this.nodes[nYindx][nNode].portlet.adjust;
                        break;
                    }
                }
                for(var nConfig=0;nConfig<oConfigExtPortal.length;nConfig++)
                {
                    var sId = (oConfigExtPortal[nConfig]["id"])?oConfigExtPortal[nConfig]["id"]:oConfigExtPortal[nConfig]["title"];
                    if(sId == this.nodes[nYindx][nNode].portlet.id)
                    {
                        oConfigExtPortal[nConfig].adj = this.nodes[nYindx][nNode].portlet.adjust;
                        break;
                    }
                }                
            }
        }
        configSetKey("gui.portal.internalcontents",oConfigPortal);
        configSetKey("gui.portal.externalcontents",oConfigExtPortal);        
    }
    
};

fileloaded();