/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

function ConfigTeams() {
	this.teams=new Array();
	this.cbok;
	this.cbcancel;
}
ConfigTeams.open = function () {
    ox.api.setModal(true);
	//showNode("modal-dialog");
	//$("modal-dialog").style.display="block";
	showNode("config_popups_win");
	$("config_popups_win").style.display="block";
	showNode("window_teams");
	centerPopupWindow($("window_teams"));
	$("window_teams").style.display="block";
}
ConfigTeams.close = function () {
	if(this.closecb) { globalalert.cbclose(); }
	hideNode("window_teams");
	$("window_teams").style.display="none";
	hideNode("config_popups_win");
	$("config_popups_win").style.display="none";
	var childs=	$("modal-dialog").childNodes;
	var closeall=true;
	for(var i=0;i<childs.length;i++) {
		if(childs[i].tagName && childs[i].tagName == "DIV") {
			if(childs[i].style.display && childs[i].style.display != "none") {
				closeall=false;
			}
		}
	}
	if(closeall) {
	    ox.api.setModal(false);
		//hideNode("modal-dialog");
		//$("modal-dialog").style.display="none";
	}
}
ConfigTeams.commitcancel = function () {
	if(configteams.cbcancel) { 
		if(configteams.cbcancel()) {
			ConfigTeams.close();
		}
	}
	else { ConfigTeams.close(); }
}
ConfigTeams.addMember = function() {
	cct_addPermanentMembers();
}
ConfigTeams.removeMember = function () {
	cct_removePermanentMembers();
}
ConfigTeams.commitok = function () {
	if(configteams.cbok) { 
		if(configteams.cbok()) {
			ConfigTeams.close();
		} 
	}
	else { ConfigTeams.close(); }
}
register("Loaded", function () {
	addOnClose($("window_teams"),function() { ConfigTeams.close() }); 
	}
);
var configteams=new ConfigTeams();

function openTeamsWindow(team_name,team_members,team_default,cbok,cbcancel) {
	if(team_members) {
		configteams.teams=clone(team_members);
	} else {
		configteams.teams=new Array();
	}
	$("team_window_team_name").value=team_name;
	$("team_default").checked=team_default;
	configteams.cbok=cbok;
	configteams.cbcancel=cbcancel;
	ConfigTeams.open();
	cct_fillMembers();
	if(configteams.teams.length>0) {
		cct_selectMember(document.getElementById("Member-"+configteams.teams[0].id));
		
	}
	
} 
var cct_beforeenter=false;
registerView("configuration/calendar/teams",
	function () {
		showNode("config_calendar_team"); 
		if(cct_participant_window == null)
			cct_createParticipants_PopUp();
		$("config_calendar_team").style.display="block";
		
		// toolbar
		if (!configToolbars.calendarTeams) {
		    configToolbars.calendarTeams = temporary.configuration.newToolbar(
		        _("Teams"), [
                    temporary.configuration.saveButton,
                    {
                        title: _("Team"),
                        id: "team",
                        buttons: [{
                            title: _("Add"),
                            id: "add",
                            icons: ["img/menu/userrights.gif",
                                    "img/menu/userrights_d.gif"],
                            event: "OX_Configuration_Teams_Add_Team"
                        }, {
                            title: _("Edit"),
                            id: "edit",
                            icons: ["img/menu/edit.gif", "img/menu/edit_d.gif"],
                            event: "OX_Configuration_Teams_Edit_Team",
                            selection: "configuration-team",
                            requires: ["one"]
                        }, {
                            title: _("Remove"),
                            id: "remove",
                            icons: ["img/menu/remove_userrights.gif",
                                    "img/menu/remove_userrights_d.gif"],
                            event: "OX_Configuration_Teams_Remove_Team",
                            selection: "configuration-team",
                            requires: ["some"]
                        }]
                    }
                ], "teams");
		}
		temporary.configuration.showToolbar(configToolbars.calendarTeams);
	},
	function () { 
				  register("OX_Configuration_Teams_Add_Team",cct_addnewTeam);
				  register("OX_Configuration_Teams_Edit_Team",cct_editTeam);
				  register("OX_Configuration_Teams_Remove_Team",cct_removenewTeam);
				  register("OX_SAVE_OBJECT",cct_saveConfiguration);
				  register("OX_Cancel_Object",cct_cancelConfiguration);
				  cct_enter();	
				},
	function()  { 
				 //configuration_askforSave();
 				 cct_leave();
				 unregister("OX_Configuration_Teams_Add_Team",cct_addnewTeam);
 				 unregister("OX_Configuration_Teams_Edit_Team",cct_editTeam);
	    	     unregister("OX_Configuration_Teams_Remove_Team",cct_removenewTeam);
	    	     unregister("OX_SAVE_OBJECT",cct_saveConfiguration);
				 unregister("OX_Cancel_Object",cct_cancelConfiguration);
				 
				},
	function () { 
		hideNode("config_calendar_team"); 
		$("config_calendar_team").style.display="none"; },
	function () { cct_enter(); }
);

function cct_saveConfiguration() {
	configSetKey("gui.calendar.teams",cct_tempteams);
	triggerEvent("OX_Save_Configuration",false,false);
}
function cct_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	cct_enter();	
}
function checkDuplicateTeams(myname) {
	for(var i=0;i<cct_tempteams.length;i++) {
		if(cct_tempteams[i].name==myname) return true;
	}
	return false;
}

var cct_currentteam=-1;
var cct_currentmember=-1;
var cct_tempteams=new Array();
var cct_participant_window = null;
function cct_enter() {
	cct_beforeenter=configuration_changed_fields["gui"];
	cct_tempteams=new Array();
	if(configContainsKey("gui.calendar.teams")) {
		cct_tempteams=configGetKey("gui.calendar.teams");
	}	
	cct_fillTeams();
	if(cct_tempteams.length>0) {
		cct_selectTeam(document.getElementById("Team-0"));
	}
	setConfigPath($("cct_header"));		
}
function cct_addnewTeam() {
	var zaehler=0;
	var myobject=new Object();
	teamname=_("New Team");
	if(checkDuplicateTeams(teamname)) { zaehler=2; }
	while(checkDuplicateTeams(teamname+"("+zaehler+")")) {
		zaehler ++;
	}
	if(zaehler!=0) {
		teamname=teamname+"("+zaehler+")";
	}
	openTeamsWindow(teamname,new Array(),false,cct_createTeam);
	configuration_changed_fields["gui"]=true;
}
function cct_editTeam() {
	openTeamsWindow(cct_tempteams[cct_currentteam].name,cct_tempteams[cct_currentteam].children,cct_tempteams[cct_currentteam].team_default,cct_changeTeam);	
	configuration_changed_fields["gui"]=true;
}
function cct_createTeam() {
	var myobject=new Object();
	if(!checkDuplicateTeams($("team_window_team_name").value)) {
		myobject.name=$("team_window_team_name").value;
		myobject.team_default=$("team_default").checked;
		if(myobject.team_default) {
			for(var i=0;i<cct_tempteams.length;i++) {
				cct_tempteams[i].team_default=false;
			}	
		}
		myobject.children=clone(configteams.teams);
	} else {
		newAlert(_("Invalid Team"),_("This Team name already exists"));
		return false;
	}
	cct_tempteams.push(myobject);
	configuration_changed_fields["gui"]=true;
	cct_fillTeams();
	cct_selectTeam(document.getElementById("Team-"+(cct_tempteams.length-1)));
	return true;
}
function cct_changeTeam() {
	var myobject=new Object();
	if(checkDuplicateTeams($("team_window_team_name").value)) {
		if($("team_window_team_name").value != cct_tempteams[cct_currentteam].name) {
			newAlert(_("Invalid Team"),_("This Team name already exists"));
			return false;		
		}
	}
	myobject.name=$("team_window_team_name").value;
	myobject.team_default=$("team_default").checked;
	if(myobject.team_default) {
		for(var i=0;i<cct_tempteams.length;i++) {
			cct_tempteams[i].team_default=false;
		}	
	}
	myobject.children=clone(configteams.teams);
	cct_tempteams[cct_currentteam] = myobject;
	configuration_changed_fields["gui"]=true;
	cct_fillTeams();
	cct_selectTeam(document.getElementById("Team-"+(cct_tempteams.length-1)));
	return true;
}

function cct_fillTeams() {
	removeChildNodes($("cct_teams"));
	for(var i=0;i<cct_tempteams.length;i++) {
		var newteam=$("ctd_template_one_row").cloneNode("false");
		var textnode=document.createTextNode(cct_tempteams[i].name);
		newteam.id="Team-"+i;
		newteam.appendChild(textnode);
		$("cct_teams").appendChild(newteam);	
	}
    ox.ToolBarController.processSelection("configuration-team", false, []);
}
function cct_selectTeam(param) {
	var allteams=param.parentNode.getElementsByTagName("div");
	for (var i=0;i<allteams.length;i++) {
		allteams[i].className = "background-color-content font-color-default";
		if(cct_tempteams[i].team_default) {
			allteams[i].style.fontStyle="italic";
			allteams[i].style.fontWeight="bold";
		} 
	}
	param.className = "background-color-PMG-selection-elements font-color-default";
	cct_currentteam=param.id.split("-")[1];
//	fillMembers();
    ox.ToolBarController.processSelection("configuration-team", false,
                                          [cct_currentteam]);
}
function cct_fillMembers() {
	removeChildNodes($("cct_members"));
	for(var i=0;i<configteams.teams.length;i++) {
		var newmember=$("ctd_template_one_member").cloneNode("false");
		var textnode=document.createTextNode(configteams.teams[i].display_name);
		newmember.id="Member-"+configteams.teams[i].id;
		newmember.appendChild(textnode);
		$("cct_members").appendChild(newmember);	
	}
	triggerEvent("SubSelectedTeamMember",0);
}

function cct_removenewTeam() {
	cct_tempteams.splice(cct_currentteam,1);
	cct_fillTeams();
    ox.ToolBarController.processSelection("configuration-team", false, []);
	if(cct_tempteams.length>0) {
		cct_selectTeam(document.getElementById("Team-0"));
	}
	configuration_changed_fields["gui"]=true;
}
function cct_addPermanentMembers() {
	cct_participant_window.openAddParticipantsWindow(); 
}
function cct_removePermanentMembers() {
	for(var z=0;z<configteams.teams.length;z++) {
		if(configteams.teams[z].id==cct_currentmember) {
			configteams.teams.splice(z,1);
			break;
		}
	}
	cct_fillMembers();
	if(configteams.teams.length>0) {
		cct_selectMember(document.getElementById("Member-"+configteams.teams[0].id))		
	} else {
		cct_currentmember=-1;
	}
}
function cct_team_name_changed() {
	var cct_inputfield=$("team_name_field");
	cct_tempteams[cct_currentteam].name=cct_inputfield.value;
	document.getElementById("Team-"+cct_currentteam).firstChild.nodeValue=cct_inputfield.value;
	configuration_changed_fields["gui"]=true;
}
function cct_createParticipants_PopUp() {
	cct_participant_window = new ParticipantsSmall(null,newPermanentUsers,true,true,true,false,"Select Users", /*i18n*/
							null,null,true,true);
	function newPermanentUsers(response) {
		for(i in response) {
		    delete response[i].contactID;
			var available=false;
			for(var z=0;z<configteams.teams.length;z++) {
				if(configteams.teams[z].id==response[i].id) {
					available=true;
					configteams.teams[z]==response[i];
					break;
				}
			}
			if(!available) {
				configteams.teams.push(response[i]);
			}
		}
		cct_fillMembers();
		if(configteams.teams.length>0) {
			cct_selectMember(document.getElementById("Member-"+configteams.teams[0].id))		
		} else {
			cct_currentmember=-1;
		}		
	}
}

function cct_leave() {
}
function cct_selectMember(param) {
	var allmembers=param.parentNode.getElementsByTagName("div");
	for (var i=0;i<allmembers.length;i++) {		
		allmembers[i].className = removeClass(allmembers[i].className,"background-color-PMG-selection-elements");
	}

	param.className += " background-color-PMG-selection-elements";
	cct_currentmember=param.id.split("-")[1];
	triggerEvent("SubSelectedTeamMember",1);
}
fileloaded();