/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.database.internal.wrapping;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/**
 * The method {@link #getConnection()} must be overwritten to return the {@link JDBC3ConnectionReturner}.
 * 
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class StatementWrapper implements Statement {

    private final Statement delegate;

    private final JDBC3ConnectionReturner con;

    /**
     * Initializes a new {@link StatementWrapper}.
     * 
     * @param delegate The delegate statement
     * @param con The connection returner
     */
    public StatementWrapper(final Statement delegate, final JDBC3ConnectionReturner con) {
        super();
        this.delegate = delegate;
        this.con = con;
    }

    public void addBatch(final String sql) throws SQLException {
        delegate.addBatch(sql);
    }

    public void cancel() throws SQLException {
        delegate.cancel();
    }

    public void clearBatch() throws SQLException {
        delegate.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        delegate.clearWarnings();
    }

    public void close() throws SQLException {
        delegate.close();
    }

    public boolean execute(final String sql) throws SQLException {
        return delegate.execute(sql);
    }

    public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
        return delegate.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
        return delegate.execute(sql, columnIndexes);
    }

    public boolean execute(final String sql, final String[] columnNames) throws SQLException {
        return delegate.execute(sql, columnNames);
    }

    public int[] executeBatch() throws SQLException {
        return delegate.executeBatch();
    }

    public ResultSet executeQuery(final String sql) throws SQLException {
        return new ResultSetWrapper(delegate.executeQuery(sql), this);
    }

    public int executeUpdate(final String sql) throws SQLException {
        return delegate.executeUpdate(sql);
    }

    public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        return delegate.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        return delegate.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
        return delegate.executeUpdate(sql, columnNames);
    }

    public Connection getConnection() throws SQLException {
        return con;
    }

    public int getFetchDirection() throws SQLException {
        return delegate.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return delegate.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new ResultSetWrapper(delegate.getGeneratedKeys(), this);
    }

    public int getMaxFieldSize() throws SQLException {
        return delegate.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return delegate.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return delegate.getMoreResults();
    }

    public boolean getMoreResults(final int current) throws SQLException {
        return delegate.getMoreResults(current);
    }

    public int getQueryTimeout() throws SQLException {
        return delegate.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return new ResultSetWrapper(delegate.getResultSet(), this);
    }

    public int getResultSetConcurrency() throws SQLException {
        return delegate.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return delegate.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return delegate.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return delegate.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return delegate.getWarnings();
    }

    public void setCursorName(final String name) throws SQLException {
        delegate.setCursorName(name);
    }

    public void setEscapeProcessing(final boolean enable) throws SQLException {
        delegate.setEscapeProcessing(enable);
    }

    public void setFetchDirection(final int direction) throws SQLException {
        delegate.setFetchDirection(direction);
    }

    public void setFetchSize(final int rows) throws SQLException {
        delegate.setFetchSize(rows);
    }

    public void setMaxFieldSize(final int max) throws SQLException {
        delegate.setMaxFieldSize(max);
    }

    public void setMaxRows(final int max) throws SQLException {
        delegate.setMaxRows(max);
    }

    public void setQueryTimeout(final int seconds) throws SQLException {
        delegate.setQueryTimeout(seconds);
    }

    @Override
    public String toString() {
        return delegate.toString();
    }
}
